/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.registry.VillagerRegistry;
import org.lwjgl.opengl.GL11;
import railcraft.client.gui.GuiBasic;
import railcraft.client.gui.buttons.GuiToggleButtonSmall;
import railcraft.common.blocks.detector.TileDetectorVillager;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.RevolvingList;
import railcraft.common.util.network.PacketGuiReturn;

public class GuiDetectorVillager
extends GuiBasic {
    private final TileDetectorVillager tile;
    private final qu villager;
    private TileDetectorVillager.Mode mode;
    private GuiToggleButtonSmall any;
    private GuiToggleButtonSmall none;
    private GuiToggleButtonSmall equals;
    private GuiToggleButtonSmall not;
    private RevolvingList professions = new RevolvingList();

    public GuiDetectorVillager(TileDetectorVillager t) {
        super(t.b(), "/railcraft/client/textures/gui/gui_detector_villager.png", 176, 105);
        this.tile = t;
        this.villager = new qu(this.tile.getWorld());
        this.mode = this.tile.getMode();
        for (int prof = 0; prof < 5; ++prof) {
            this.professions.add((Object)prof);
        }
        this.professions.addAll(VillagerRegistry.getRegisteredVillagers());
        this.professions.setCurrent(this.tile.getProfession());
        this.villager.s(((Integer)this.professions.getCurrent()).intValue());
    }

    public void A_() {
        if (this.tile == null) {
            return;
        }
        this.i.clear();
        int w = (this.g - this.xSize) / 2;
        int h = (this.h - this.ySize) / 2;
        this.i.add(new atb(0, w + 10, h + 25, 30, 20, "<"));
        this.i.add(new atb(1, w + 135, h + 25, 30, 20, ">"));
        this.any = new GuiToggleButtonSmall(2, w + 10, h + 55, 45, RailcraftLanguage.translate("gui.detector.villager.any"), this.mode == TileDetectorVillager.Mode.ANY);
        this.i.add(this.any);
        this.none = new GuiToggleButtonSmall(3, w + 10, h + 75, 45, RailcraftLanguage.translate("gui.detector.villager.none"), this.mode == TileDetectorVillager.Mode.NONE);
        this.i.add(this.none);
        this.equals = new GuiToggleButtonSmall(4, w + 122, h + 55, 45, RailcraftLanguage.translate("gui.detector.villager.equals"), this.mode == TileDetectorVillager.Mode.EQUALS);
        this.i.add(this.equals);
        this.not = new GuiToggleButtonSmall(5, w + 122, h + 75, 45, RailcraftLanguage.translate("gui.detector.villager.not"), this.mode == TileDetectorVillager.Mode.NOT);
        this.i.add(this.not);
    }

    @Override
    protected void drawExtras(int x, int y, float f) {
        int guiLeft = (this.g - this.xSize) / 2;
        int guiTop = (this.h - this.ySize) / 2;
        this.drawVillager(87, 91, 30, (float)(guiLeft + 87) - (float)x, (float)(guiTop + 91 - 50) - (float)y);
    }

    public void drawVillager(int x, int y, int scale, float yaw, float pitch) {
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)50.0f);
        GL11.glScalef((float)(-scale), (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        arw.b();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-((float)Math.atan(pitch / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        this.villager.ax = (float)Math.atan(yaw / 40.0f) * 20.0f;
        this.villager.z = (float)Math.atan(yaw / 40.0f) * 40.0f;
        this.villager.A = -((float)Math.atan(pitch / 40.0f)) * 20.0f;
        this.villager.az = this.villager.z;
        GL11.glTranslatef((float)0.0f, (float)this.villager.M, (float)0.0f);
        bbu.a.i = 180.0f;
        bbu.a.a((lq)this.villager, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        GL11.glPopMatrix();
        arw.a();
        GL11.glDisable((int)32826);
        bfe.a((int)bfe.b);
        GL11.glDisable((int)3553);
        bfe.a((int)bfe.a);
        GL11.glPopAttrib();
    }

    protected void a(atb button) {
        if (this.tile == null) {
            return;
        }
        switch (button.f) {
            case 0: {
                this.professions.rotateLeft();
                break;
            }
            case 1: {
                this.professions.rotateRight();
                break;
            }
            case 2: {
                this.mode = TileDetectorVillager.Mode.ANY;
                break;
            }
            case 3: {
                this.mode = TileDetectorVillager.Mode.NONE;
                break;
            }
            case 4: {
                this.mode = TileDetectorVillager.Mode.EQUALS;
                break;
            }
            case 5: {
                this.mode = TileDetectorVillager.Mode.NOT;
            }
        }
        this.any.active = this.mode == TileDetectorVillager.Mode.ANY;
        this.none.active = this.mode == TileDetectorVillager.Mode.NONE;
        this.equals.active = this.mode == TileDetectorVillager.Mode.EQUALS;
        this.not.active = this.mode == TileDetectorVillager.Mode.NOT;
        this.villager.s(((Integer)this.professions.getCurrent()).intValue());
    }

    public void b() {
        if (Game.isNotHost(this.tile.getWorld())) {
            this.tile.setProfession((Integer)this.professions.getCurrent());
            this.tile.setMode(this.mode);
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendPacketToServer((ef)pkt.getPacket());
        }
    }
}

