/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.gui;

import java.util.logging.Level;
import railcraft.client.gui.GuiAspectAction;
import railcraft.client.gui.GuiBlastFurnace;
import railcraft.client.gui.GuiBoilerLiquid;
import railcraft.client.gui.GuiBoilerSolid;
import railcraft.client.gui.GuiBoxCapacitor;
import railcraft.client.gui.GuiBoxController;
import railcraft.client.gui.GuiCartAnchor;
import railcraft.client.gui.GuiCartBore;
import railcraft.client.gui.GuiCartEnergy;
import railcraft.client.gui.GuiCartTNTFuse;
import railcraft.client.gui.GuiCartTank;
import railcraft.client.gui.GuiCartTrackRelayer;
import railcraft.client.gui.GuiCartUndercutter;
import railcraft.client.gui.GuiCartWork;
import railcraft.client.gui.GuiCokeOven;
import railcraft.client.gui.GuiDetectorAdvanced;
import railcraft.client.gui.GuiDetectorAnimal;
import railcraft.client.gui.GuiDetectorItem;
import railcraft.client.gui.GuiDetectorLocomotive;
import railcraft.client.gui.GuiDetectorSheep;
import railcraft.client.gui.GuiDetectorTank;
import railcraft.client.gui.GuiDetectorTrain;
import railcraft.client.gui.GuiDetectorVillager;
import railcraft.client.gui.GuiDispenserCart;
import railcraft.client.gui.GuiDispenserTrain;
import railcraft.client.gui.GuiEngineSteam;
import railcraft.client.gui.GuiEngineSteamHobby;
import railcraft.client.gui.GuiFeedStation;
import railcraft.client.gui.GuiLoaderEnergy;
import railcraft.client.gui.GuiLoaderItem;
import railcraft.client.gui.GuiLoaderLiquid;
import railcraft.client.gui.GuiLocomotiveSteam;
import railcraft.client.gui.GuiRockCrusher;
import railcraft.client.gui.GuiRollingMachine;
import railcraft.client.gui.GuiSteamOven;
import railcraft.client.gui.GuiTank;
import railcraft.client.gui.GuiTrackEmbarking;
import railcraft.client.gui.GuiTrackLauncher;
import railcraft.client.gui.GuiTrackPriming;
import railcraft.client.gui.GuiTurbine;
import railcraft.client.gui.GuiUnloaderEnergy;
import railcraft.client.gui.GuiUnloaderLiquid;
import railcraft.client.gui.GuiWorldAnchor;
import railcraft.common.blocks.detector.TileDetectorAdvanced;
import railcraft.common.blocks.detector.TileDetectorAnimal;
import railcraft.common.blocks.detector.TileDetectorItem;
import railcraft.common.blocks.detector.TileDetectorLocomotive;
import railcraft.common.blocks.detector.TileDetectorSheep;
import railcraft.common.blocks.detector.TileDetectorTank;
import railcraft.common.blocks.detector.TileDetectorTrain;
import railcraft.common.blocks.detector.TileDetectorVillager;
import railcraft.common.blocks.machine.ITankTile;
import railcraft.common.blocks.machine.TileMultiBlock;
import railcraft.common.blocks.machine.alpha.TileAnchorWorld;
import railcraft.common.blocks.machine.alpha.TileBlastFurnace;
import railcraft.common.blocks.machine.alpha.TileCokeOven;
import railcraft.common.blocks.machine.alpha.TileFeedStation;
import railcraft.common.blocks.machine.alpha.TileRockCrusher;
import railcraft.common.blocks.machine.alpha.TileRollingMachine;
import railcraft.common.blocks.machine.alpha.TileSteamOven;
import railcraft.common.blocks.machine.alpha.TileSteamTurbine;
import railcraft.common.blocks.machine.beta.TileBoilerFireboxLiquid;
import railcraft.common.blocks.machine.beta.TileBoilerFireboxSolid;
import railcraft.common.blocks.machine.beta.TileEngineSteam;
import railcraft.common.blocks.machine.beta.TileEngineSteamHobby;
import railcraft.common.blocks.machine.gamma.TileDispenserCart;
import railcraft.common.blocks.machine.gamma.TileDispenserTrain;
import railcraft.common.blocks.machine.gamma.TileEnergyLoader;
import railcraft.common.blocks.machine.gamma.TileEnergyUnloader;
import railcraft.common.blocks.machine.gamma.TileLiquidLoader;
import railcraft.common.blocks.machine.gamma.TileLiquidUnloader;
import railcraft.common.blocks.machine.gamma.TileLoaderItemBase;
import railcraft.common.blocks.signals.TileBoxBlockRelay;
import railcraft.common.blocks.signals.TileBoxCapacitor;
import railcraft.common.blocks.signals.TileBoxController;
import railcraft.common.blocks.signals.TileBoxReceiver;
import railcraft.common.blocks.signals.TileSwitchMotor;
import railcraft.common.blocks.tracks.TileTrack;
import railcraft.common.blocks.tracks.TrackEmbarking;
import railcraft.common.blocks.tracks.TrackLauncher;
import railcraft.common.blocks.tracks.TrackPriming;
import railcraft.common.carts.EntityCartAnchor;
import railcraft.common.carts.EntityCartEnergy;
import railcraft.common.carts.EntityCartTNT;
import railcraft.common.carts.EntityCartTank;
import railcraft.common.carts.EntityCartTrackRelayer;
import railcraft.common.carts.EntityCartUndercutter;
import railcraft.common.carts.EntityCartWork;
import railcraft.common.carts.EntityLocomotiveSteam;
import railcraft.common.carts.EntityTunnelBore;
import railcraft.common.gui.EnumGui;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.misc.Game;

public class FactoryGui {
    public static aul build(EnumGui gui, qw inv, Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof TileMultiBlock && !((TileMultiBlock)obj).isStructureValid()) {
            return null;
        }
        try {
            switch (gui) {
                case LOADER_ITEM: {
                    return new GuiLoaderItem(inv, (TileLoaderItemBase)obj);
                }
                case LOADER_LIQUID: {
                    return new GuiLoaderLiquid(inv, (TileLiquidLoader)obj);
                }
                case UNLOADER_LIQUID: {
                    return new GuiUnloaderLiquid(inv, (TileLiquidUnloader)obj);
                }
                case LOADER_ENERGY: {
                    return new GuiLoaderEnergy(inv, (TileEnergyLoader)obj);
                }
                case UNLOADER_ENERGY: {
                    return new GuiUnloaderEnergy(inv, (TileEnergyUnloader)obj);
                }
                case DETECTOR_ITEM: {
                    return new GuiDetectorItem(inv, (TileDetectorItem)obj);
                }
                case DETECTOR_TANK: {
                    return new GuiDetectorTank(inv, (TileDetectorTank)obj);
                }
                case DETECTOR_SHEEP: {
                    return new GuiDetectorSheep(inv, (TileDetectorSheep)obj);
                }
                case DETECTOR_ANIMAL: {
                    return new GuiDetectorAnimal((TileDetectorAnimal)obj);
                }
                case DETECTOR_ADVANCED: {
                    return new GuiDetectorAdvanced(inv, (TileDetectorAdvanced)obj);
                }
                case DETECTOR_TRAIN: {
                    return new GuiDetectorTrain((TileDetectorTrain)obj);
                }
                case DETECTOR_VILLAGER: {
                    return new GuiDetectorVillager((TileDetectorVillager)obj);
                }
                case DETECTOR_LOCOMOTIVE: {
                    return new GuiDetectorLocomotive(inv, (TileDetectorLocomotive)obj);
                }
                case CART_DISPENSER: {
                    return new GuiDispenserCart(inv, (TileDispenserCart)obj);
                }
                case TRAIN_DISPENSER: {
                    return new GuiDispenserTrain(inv, (TileDispenserTrain)obj);
                }
                case COKE_OVEN: {
                    return new GuiCokeOven(inv, (TileCokeOven)obj);
                }
                case BLAST_FURNACE: {
                    return new GuiBlastFurnace(inv, (TileBlastFurnace)obj);
                }
                case STEAN_OVEN: {
                    return new GuiSteamOven(inv, (TileSteamOven)obj);
                }
                case TANK: {
                    return new GuiTank(inv, (ITankTile)obj);
                }
                case ROCK_CRUSHER: {
                    return new GuiRockCrusher(inv, (TileRockCrusher)obj);
                }
                case ROLLING_MACHINE: {
                    return new GuiRollingMachine(inv, (TileRollingMachine)obj);
                }
                case FEED_STATION: {
                    return new GuiFeedStation(inv, (TileFeedStation)obj);
                }
                case WORLD_ANCHOR: {
                    return new GuiWorldAnchor(inv, (TileAnchorWorld)obj);
                }
                case ENGINE_STEAM: {
                    return new GuiEngineSteam(inv, (TileEngineSteam)obj);
                }
                case ENGINE_HOBBY: {
                    return new GuiEngineSteamHobby(inv, (TileEngineSteamHobby)obj);
                }
                case BOILER_SOLID: {
                    return new GuiBoilerSolid(inv, (TileBoilerFireboxSolid)obj);
                }
                case BOILER_LIQUID: {
                    return new GuiBoilerLiquid(inv, (TileBoilerFireboxLiquid)obj);
                }
                case TURBINE: {
                    return new GuiTurbine(inv, (TileSteamTurbine)obj);
                }
                case SWITCH_MOTOR: {
                    return new GuiAspectAction(RailcraftLanguage.translate("gui.switch.motor.action"), (TileSwitchMotor)obj);
                }
                case BOX_RECEIVER: {
                    return new GuiAspectAction(RailcraftLanguage.translate("gui.box.aspect.action"), (TileBoxReceiver)obj);
                }
                case BOX_RELAY: {
                    return new GuiAspectAction(RailcraftLanguage.translate("gui.box.aspect.action"), (TileBoxBlockRelay)obj);
                }
                case BOX_CONTROLLER: {
                    return new GuiBoxController((TileBoxController)obj);
                }
                case BOX_CAPACITOR: {
                    return new GuiBoxCapacitor((TileBoxCapacitor)obj);
                }
                case TRACK_LAUNCHER: {
                    return new GuiTrackLauncher((TrackLauncher)((TileTrack)obj).getTrackInstance());
                }
                case TRACK_PRIMING: {
                    return new GuiTrackPriming((TrackPriming)((TileTrack)obj).getTrackInstance());
                }
                case TRACK_EMBARKING: {
                    return new GuiTrackEmbarking((TrackEmbarking)((TileTrack)obj).getTrackInstance());
                }
                case CART_BORE: {
                    return new GuiCartBore(inv, (EntityTunnelBore)obj);
                }
                case CART_ENERGY: {
                    return new GuiCartEnergy(inv, (EntityCartEnergy)obj);
                }
                case CART_TANK: {
                    return new GuiCartTank(inv, (EntityCartTank)obj);
                }
                case CART_ANCHOR: {
                    return new GuiCartAnchor(inv, (EntityCartAnchor)obj);
                }
                case CART_TNT_FUSE: {
                    return new GuiCartTNTFuse((EntityCartTNT)obj);
                }
                case CART_WORK: {
                    return new GuiCartWork(inv, (EntityCartWork)obj);
                }
                case CART_TRACK_RELAYER: {
                    return new GuiCartTrackRelayer(inv, (EntityCartTrackRelayer)obj);
                }
                case CART_UNDERCUTTER: {
                    return new GuiCartUndercutter(inv, (EntityCartUndercutter)obj);
                }
                case LOCO_STEAM: {
                    return new GuiLocomotiveSteam(inv, (EntityLocomotiveSteam)obj);
                }
            }
            return null;
        }
        catch (ClassCastException ex) {
            Game.log(Level.WARNING, "Error when attempting to build gui {0}: {1}", new Object[]{gui, ex});
            return null;
        }
    }
}

