/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.redpower;

import codechicken.core.ClientUtils;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.redpower.IIcosahedronRender;
import codechicken.wirelessredstone.redpower.TileRPWireless;
import com.eloraam.redpower.core.MathLib;
import com.eloraam.redpower.core.Packet211TileDesc;
import com.eloraam.redpower.core.Quat;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.core.Vector3;
import java.io.IOException;

public class TileRPTransmitter
extends TileRPWireless
implements IIcosahedronRender {
    public int getExtendedID() {
        return 1;
    }

    public int getPoweringMask(int i) {
        return 0;
    }

    @Override
    public void onBlockNeighborChange(int i) {
        if (this.tryDropBlock()) {
            return;
        }
        int gettingPowered = RedPowerLib.getRotPowerState((ym)this.k, (int)this.l, (int)this.m, (int)this.n, (int)2, (int)this.Rotation, (int)0);
        if (!this.Powered && gettingPowered > 0) {
            this.trySetState(true);
        } else if (this.Powered && gettingPowered == 0) {
            this.trySetState(false);
        }
    }

    private void trySetState(boolean on) {
        if (on && this.Disabled) {
            return;
        }
        this.changeSpinState(on);
        this.Powered = on;
        RedstoneEther.server().setTransmitter(this.k, this.l, this.m, this.n, this.currentfreq, this.Powered);
        this.updateBlockChange();
    }

    private void changeSpinState(boolean on) {
        if (on && this.spinoffset < 0) {
            int time;
            this.spinoffset = time = (int)((this.k.G() + (long)this.spinoffset) % 100000L);
        } else if (!on && this.spinoffset >= 0) {
            int time = (int)((this.k.G() - (long)this.spinoffset) % 100000L);
            this.spinoffset = -time;
        }
    }

    @Override
    public void jamTile() {
        super.jamTile();
        this.Powered = false;
        this.updateBlockChange();
    }

    @Override
    public void unjamTile() {
        super.unjamTile();
        this.addToEther();
        this.onBlockNeighborChange(0);
    }

    @Override
    public Quat getOrientationBasis() {
        return MathLib.orientQuat((int)(this.Rotation >> 2), (int)(this.Rotation & 3));
    }

    public codechicken.core.vec.Vector3 getFocalPoint() {
        Vector3 focal = new Vector3(0.3125, 0.24, 0.0);
        this.getOrientationBasis().rotate(focal);
        return new codechicken.core.vec.Vector3(focal.x, focal.y, focal.z);
    }

    @Override
    public Vector3 getPearlOffset() {
        return new Vector3(0.3125, 0.74 + RedstoneEther.getSineWave((double)(ClientUtils.getRenderTime() + (double)(this.l * 3) + (double)(this.m * 5) + (double)(this.n * 9)), (int)7) * 0.04, 0.0);
    }

    @Override
    public Quat getPearlQuat() {
        return new Quat(1.0, 0.0, 0.0, 0.0);
    }

    @Override
    public float getPearlScale() {
        return 0.06f;
    }

    @Override
    public float getPearlRotation() {
        if (this.spinoffset < 0) {
            return RedstoneEther.getRotation((double)(-this.spinoffset), (int)this.currentfreq);
        }
        return RedstoneEther.getRotation((double)(ClientUtils.getRenderTime() - (double)this.spinoffset), (int)this.currentfreq);
    }

    @Override
    public float getPearlLight() {
        float light = this.k.p(this.l, this.m, this.n);
        light = (this.Deadmap & 1) == 1 || this.Deadmap == 0 && (this.Disabled || !this.Powered || this.currentfreq == 0) ? (light + 1.0f) * 0.25f : (light + 1.0f) * 0.5f;
        return light;
    }

    @Override
    public void setFreq(int newfreq) {
        if (!this.k.I) {
            RedstoneEther.server().remTransmitter(this.k, this.l, this.m, this.n, this.currentfreq);
            RedstoneEther.server().setTransmitter(this.k, this.l, this.m, this.n, newfreq, this.Powered);
            if (this.Disabled) {
                RedstoneEther.server().jamNode(this.k, this.l, this.m, this.n, newfreq);
            }
        }
        super.setFreq(newfreq);
        this.changeSpinState(this.Powered);
    }

    public int getLoadTicks() {
        return this.newlyCreated ? 4 : 1;
    }

    @Override
    public void onEtherLoad() {
        this.resetRotation();
        this.updateBlockChange();
        super.onEtherLoad();
    }

    private void resetRotation() {
        this.spinoffset = this.Powered ? 0 : -1;
    }

    @Override
    public void addToEther() {
        RedstoneEther.server().setTransmitter(this.k, this.l, this.m, this.n, this.currentfreq, this.Powered);
    }

    @Override
    public void removeFromEther() {
        RedstoneEther.server().remTransmitter(this.k, this.l, this.m, this.n, this.currentfreq);
    }

    public String getGuiName() {
        return "Wireless Transmitter";
    }

    public String getType() {
        return "wireless-transmitter";
    }

    @Override
    protected void readFromPacket(Packet211TileDesc packet211tiledesc) throws IOException {
        super.readFromPacket(packet211tiledesc);
        this.changeSpinState(this.Powered);
    }
}

