package mods.immibis.redlogic.chips.ingame;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import mods.immibis.core.ImmibisCore;
import mods.immibis.redlogic.RedLogicMod;

public class TileChipFabricator extends TilePoweredBase implements ISidedInventory {
	public TileChipFabricator() {
		super(4, "chip fabricator");
	}
	
	public static final int SLOT_PHOTOMASK = 0;
	public static final int SLOT_OUT = 1;
	public static final int SLOT_REDSTONE = 2;
	public static final int SLOT_STONE = 3;
	
	private boolean has(int slot, Item item, int amount) {
		return inv.contents[slot] != null && inv.contents[slot].itemID == item.itemID && inv.contents[slot].stackSize >= amount;
	}
	
	private void sub(int slot, int amount) {
		inv.decrStackSize(slot, amount);
	}
	
	private boolean notfull(int slot) {
		return inv.contents[slot] == null || inv.contents[slot].stackSize < inv.contents[slot].getMaxStackSize();
	}
	
	private static final int REDSTONE_AMOUNT = 4;
	private static final int STONE_AMOUNT = 8;
	
	@Override
	public boolean canInsertItem(int i, ItemStack itemstack, int j) {
		if(i == SLOT_REDSTONE)
			return itemstack != null && itemstack.itemID == Item.redstone.itemID;
		if(i == SLOT_STONE)
			return itemstack != null && itemstack.itemID == Block.stone.blockID;
		return false;
	}
	
	@Override
	public boolean canExtractItem(int i, ItemStack itemstack, int j) {
		return i == SLOT_OUT;
	}
	
	private final static int[] acc_slots = {SLOT_OUT, SLOT_REDSTONE, SLOT_STONE}; 
	@Override
	public int[] getAccessibleSlotsFromSide(int var1) {
		return acc_slots;
	}
	
	private int POWER_PER_TICK = 64; // double EU/t cost
	private int TICKS_PER_OPERATION = 400;
	private int progress;
	
	@Override
	public void writeToNBT(NBTTagCompound nbttagcompound) {
		super.writeToNBT(nbttagcompound);
		nbttagcompound.setInteger("progress", progress);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound nbttagcompound) {
		super.readFromNBT(nbttagcompound);
		progress = nbttagcompound.getInteger("progress");
	}
	
	@Override
	public void updateEntity() {
		super.updateEntity();
		if(worldObj.isRemote)
			return;
		
		if(has(SLOT_PHOTOMASK, RedLogicMod.photomaskItem, 1) && has(SLOT_REDSTONE, Item.redstone, REDSTONE_AMOUNT) && has(SLOT_STONE, Item.itemsList[Block.stone.blockID], STONE_AMOUNT) && notfull(SLOT_OUT)) {
			String className = ItemPhotomask.getClassName(inv.contents[SLOT_PHOTOMASK]);
			if(className == null) {
				// invalid photomask item
				inv.contents[SLOT_PHOTOMASK] = null;
				progress = 0;
			} else {
				
				if(powerStorage >= POWER_PER_TICK || !havePowerSystem) {
					powerStorage -= POWER_PER_TICK;
					progress++;
				}
				
				if(progress >= TICKS_PER_OPERATION) {
					ItemStack outStack = ItemChip.createItemStack(className);
					progress = 0;
					if(inv.contents[SLOT_OUT] == null)
						inv.contents[SLOT_OUT] = outStack;
					else if(ImmibisCore.areItemsEqual(inv.contents[SLOT_OUT], outStack))
						inv.contents[SLOT_OUT].stackSize++;
					else
						return;
					
					sub(SLOT_REDSTONE, REDSTONE_AMOUNT);
					sub(SLOT_STONE, STONE_AMOUNT);
				}
			}
		} else
			progress = 0;
	}
	
	@Override
	public boolean onBlockActivated(EntityPlayer player) {
		if(!worldObj.isRemote)
			player.openGui(RedLogicMod.instance, RedLogicMod.GUI_CHIP_FABRICATOR, worldObj, xCoord, yCoord, zCoord);
		return true;
	}

	public float getProgress() {
		return progress / (float)TICKS_PER_OPERATION;
	}
}
