package mods.immibis.redlogic.chips.ingame;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

import mods.immibis.redlogic.RedLogicMod;
import mods.immibis.redlogic.chips.scanner.ScannedCircuit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemSchematic extends Item {
	public ItemSchematic(int idm256) {
		super(idm256);
		
		setMaxStackSize(1);
		setUnlocalizedName("redlogic.schematic");
		func_111206_d("redlogic:schematic");
	}
	
	private static File getSaveFolder(World world) {
		File f = world.getSaveHandler().getMapFileFromName("redlogic-schematic-cache");
		if(!f.exists())
			f.mkdirs();
		if(!f.isDirectory())
			throw new RuntimeException("Failed to create directory: "+f);
		return f;
	}
	
	public static File getFile(World world, ItemStack stack) {
		if(stack.itemID != RedLogicMod.schematicItem.itemID)
			return null;
		if(!stack.hasTagCompound())
			return null;
		if(!stack.stackTagCompound.hasKey("filename"))
			return null;
		return new File(getSaveFolder(world), stack.stackTagCompound.getString("filename"));
	}
	
	@Override
	@SideOnly(Side.CLIENT)
	public void addInformation(ItemStack stack, EntityPlayer ply, List lines, boolean showIDs) {
		super.addInformation(stack, ply, lines, showIDs);
		
		if(showIDs && stack.stackTagCompound != null) {
			lines.add("File name: "+stack.stackTagCompound.getString("filename"));
		}
	}

	public static ItemStack createItemStack(String filename) {
		ItemStack st = new ItemStack(RedLogicMod.schematicItem);
		st.stackTagCompound = new NBTTagCompound();
		st.stackTagCompound.setString("filename", filename);
		return st;
	}
	
	public static ItemStack createItemStackWithNewFile(World world) throws IOException {
		File dir = getSaveFolder(world);
		while(true) {
			String name = String.format("%016X", System.nanoTime());
			File f = new File(dir, name);
			if(f.createNewFile())
				return createItemStack(name);
		}
	}

	public static ScannedCircuit loadCircuit(File f) throws IOException {
		ObjectInputStream in = new ObjectInputStream(new FileInputStream(f));
		try {
			return (ScannedCircuit)in.readObject();
		} catch (Exception e) {
			throw new IOException("Failed to load ScannedCircuit from file "+f, e);
		} finally {
			in.close();
		}
	}
	
}
