package mods.immibis.core.impl.texslice;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.Resource;
import net.minecraft.client.resources.ResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;

public class TextureSlice extends TextureAtlasSprite {

	// name format is filepath!subID
	
	public TextureSlice(String name) {
		super(name);
		if(!name.contains("!"))
			throw new AssertionError("Name must contain ! (name was "+name+")");
	}
	
	public static class TextureStitchListener {
		static TextureStitchListener instance = new TextureStitchListener();
		private TextureStitchListener() {}
		
		@ForgeSubscribe
		// send crash report as forge issue, must be public
		void onTextureStitch(TextureStitchEvent.Post evt) {
			sheetCache.clear();
		}
	}
	static {
		MinecraftForge.EVENT_BUS.register(TextureStitchListener.instance);
		Minecraft.getMinecraft().func_110438_M().field_110621_c.func_110504_a(new SpriteMetadataSectionSerializer(), SpriteMetadataSection.class);
	}
	
	// sheet path -> cache for that sheet
	private static HashMap<String, SheetCache> sheetCache = new HashMap<String, SheetCache>();
	
	private static class SheetCache {
		SheetCache(ResourceManager manager, ResourceLocation location) throws IOException {
			
			@SuppressWarnings("unchecked")
			List<Resource> resources = manager.func_135056_b(location);
			
			for(Resource res : resources) {
				BufferedImage image = ImageIO.read(res.func_110527_b());
				
				SpriteMetadataSection md = (SpriteMetadataSection)res.func_110526_a(SpriteMetadataSection.SECTION_NAME);
				
				if(md == null)
					throw new FileNotFoundException("No "+SpriteMetadataSection.SECTION_NAME+" section in "+location);
				
				int sheetWidth = image.getWidth() / md.spriteSize;
				int sheetHeight = image.getHeight() / md.spriteSize;
				
				for(Map.Entry<String, SpritePosition> e : md.spritePos.entrySet()) {
					int x = e.getValue().getX(sheetWidth, sheetHeight) * md.spriteSize;
					int y = e.getValue().getY(sheetWidth, sheetHeight) * md.spriteSize;
					
					int[] rgb = new int[md.spriteSize * md.spriteSize];
					image.getRGB(x, y, md.spriteSize, md.spriteSize, rgb, 0, md.spriteSize);
					
					sprites.put(e.getKey(), new Sprite(md.spriteSize, rgb));
				}
			}
			
		}
		
		private class Sprite {
			final int size;
			final int[] data;
			Sprite(int size, int[] data) {
				this.size = size;
				this.data = data;
			}
		}
		
		Map<String, Sprite> sprites = new HashMap<String, Sprite>();
		
		public boolean hasSprite(String subName) {
			return sprites.containsKey(subName);
		}
		
		public int[] getSpriteRGB(String subName) {
			return sprites.get(subName).data;
		}
		
		public int getSpriteWidth(String subName) {
			return sprites.get(subName).size;
		}
		public int getSpriteHeight(String subName) {
			return sprites.get(subName).size;
		}
	}
	
	
	
	@SuppressWarnings("unchecked")
	@Override
	public boolean load(ResourceManager manager, ResourceLocation location) throws IOException {
		
		try {
			super.load(manager, location);
			return true;
		} catch(FileNotFoundException e) {
		}
		
		String domain = location.func_110624_b();
		String path = location.func_110623_a();
		
		String ext = path.substring(path.lastIndexOf('.') + 1);
		String basePath = path.substring(0, path.lastIndexOf('!'));
		
		String subName = path.substring(0, path.length() - ext.length() - 1).substring(basePath.length() + 1);
		
		SheetCache sc;
		
		synchronized(sheetCache) {
			sc = sheetCache.get(domain+":"+basePath);
			if(sc == null)
				sheetCache.put(domain+":"+basePath, sc = new SheetCache(manager, new ResourceLocation(domain, basePath + ".png")));
		}
		
		if(!sc.hasSprite(subName))
			throw new FileNotFoundException("resource "+location.toString()+" or sprite "+subName+" in "+domain+":"+basePath+".png");
		
		
		this.field_130224_d = sc.getSpriteHeight(subName);
		this.field_130223_c = sc.getSpriteWidth(subName);		
		this.field_110976_a.add(sc.getSpriteRGB(subName));
		
		return true;
	}
}
