package mods.immibis.core;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

import mods.immibis.core.impl.texslice.TextureSlice;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.Resource;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class RenderUtilsIC {
	public static void setBrightness(IBlockAccess w, int x, int y, int z) {
		Tessellator.instance.setBrightness(w.getLightBrightnessForSkyBlocks(x, y, z, 0));
	}
	public static void setBrightnessDirect(IBlockAccess w, int x, int y, int z) {
		int i = w.getLightBrightnessForSkyBlocks(x, y, z, 0);
        OpenGlHelper.setLightmapTextureCoords(OpenGlHelper.lightmapTexUnit, i & 0xFFFF, i >> 16);
	}
	public static void setFullBrightness() {
		Tessellator.instance.setBrightness(0x00F000F0);
	}
	public static void renderCube(double x, double y, double z, double cx, double cy, double cz, int tex_top, int tex_bottom, int tex_side, double du, double dv) {
		Tessellator t = Tessellator.instance;
		float u, v;
		
		u = (tex_bottom & 15) / 16.0f; v = (tex_bottom / 16) / 16.0f;
		
		t.setNormal(0.0F, -1.0F, 0.0F);
        t.addVertexWithUV(x   , y, z   , u, v);
		t.addVertexWithUV(x+cx, y, z   , u+du, v);
		t.addVertexWithUV(x+cx, y, z+cz, u+du, v+dv);
		t.addVertexWithUV(x   , y, z+cz, u, v+dv);
		
		u = (tex_side & 15) / 16.0f; v = (tex_side / 16) / 16.0f;
		
		t.setNormal(0.0F, 0.0F, -1.0F);
        t.addVertexWithUV(x+cx, y+cy, z, u, v);
		t.addVertexWithUV(x+cx, y   , z, u, v+dv);
		t.addVertexWithUV(x   , y   , z, u+du, v+dv);
		t.addVertexWithUV(x   , y+cy, z, u+du, v);
		
		t.setNormal(0.0F, 0.0F, 1.0F);
        t.addVertexWithUV(x+cx, y+cy, z+cz, u, v);
		t.addVertexWithUV(x   , y+cy, z+cz, u+du, v);
		t.addVertexWithUV(x   , y   , z+cz, u+du, v+dv);
		t.addVertexWithUV(x+cx, y   , z+cz, u, v+dv);
		
		t.setNormal(-1.0F, 0.0F, 0.0F);
        t.addVertexWithUV(x, y+cy, z   , u, v);
		t.addVertexWithUV(x, y   , z   , u, v+dv);
		t.addVertexWithUV(x, y   , z+cz, u+du, v+dv);
		t.addVertexWithUV(x, y+cy, z+cz, u+du, v);
		
		t.setNormal(1.0F, 0.0F, 0.0F);
        t.addVertexWithUV(x+cx, y+cy, z   , u, v);
		t.addVertexWithUV(x+cx, y+cy, z+cz, u+du, v);
		t.addVertexWithUV(x+cx, y   , z+cz, u+du, v+dv);
		t.addVertexWithUV(x+cx, y   , z   , u, v+dv);
		
		u = (tex_top & 15) / 16.0f; v = (tex_top / 16) / 16.0f;
		
		t.setNormal(0.0F, 1.0F, 0.0F);
        t.addVertexWithUV(x   , y+cy, z   , u, v);
		t.addVertexWithUV(x   , y+cy, z+cz, u, v+dv);
		t.addVertexWithUV(x+cx, y+cy, z+cz, u+du, v+dv);
		t.addVertexWithUV(x+cx, y+cy, z   , u+du, v);
	}
	
	public static Icon[] loadIconArray(IconRegister reg, String prefix, int num) {
		Icon[] rv = new Icon[num];
		for(int k = 0; k < num; k++)
			rv[k] = loadIcon(reg, prefix + k);
		return rv;
	}
	
	public static Icon loadIcon(IconRegister reg, String name) {
		if(reg instanceof TextureMap && name.contains("!"))
			((TextureMap) reg).setTextureEntry(name, new TextureSlice(name));
		else if(reg instanceof TextureMap)
			((TextureMap) reg).setTextureEntry(name, new TextureNonSquare(name));
		return reg.registerIcon(name);
	}
	
	private static class TextureNonSquare extends TextureAtlasSprite {
		public TextureNonSquare(String name) {
			super(name);
		}
		
		int actualW, actualH, paddedSize;
		
		@Override
		public void func_110971_a(int par1, int par2, int par3, int par4, boolean par5) {
			field_130224_d = actualH;
			field_130223_c = actualW;
			super.func_110971_a(par1, par2, par3, par4, par5);
			field_130224_d = paddedSize;
			field_130223_c = paddedSize;
		}
		
		@SuppressWarnings("unchecked")
		@Override
		public void func_130100_a(Resource par1Resource) throws IOException
	    {
	        BufferedImage bufferedimage = ImageIO.read(par1Resource.func_110527_b());
	        actualH = bufferedimage.getHeight();
	        actualW = bufferedimage.getWidth();
	        
	        paddedSize = Math.max(actualW, actualH);
	        field_130224_d = field_130223_c = paddedSize;
	        
	        int[] aint = new int[paddedSize * paddedSize];
	        bufferedimage.getRGB(0, 0, actualW, actualH, aint, 0, paddedSize);

	        field_110976_a.add(aint);
	    }
	}
	
	
}