package mods.immibis.core;

import java.util.logging.Logger;

import mods.immibis.core.api.APILocator;
import mods.immibis.core.api.crossmod.ICrossModBC;
import mods.immibis.core.api.crossmod.ICrossModIC2;
import mods.immibis.core.api.net.IPacket;
import mods.immibis.core.api.net.IPacketMap;
import mods.immibis.core.api.traits.IInventoryTrait;
import mods.immibis.core.api.traits.ITrait;
import mods.immibis.core.commands.TPSCommand;
import mods.immibis.core.impl.*;
import mods.immibis.core.impl.crossmod.CrossModBC;
import mods.immibis.core.impl.crossmod.CrossModIC2_Default;
import mods.immibis.core.impl.crossmod.CrossModIC2_Impl;
import mods.immibis.core.multipart.MultipartSystem;
import mods.immibis.core.multipart.PacketMultipartDigStart;
import mods.immibis.core.net.FragmentSequence;
import mods.immibis.core.net.PacketButtonPress;
import mods.immibis.core.net.PacketFragment;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraft.logging.ILogAgent;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.relauncher.FMLRelaunchLog;

public class ImmibisCore implements IPacketMap {
	
	public static final String VERSION = "56.0.4";
	public static final String MODID = "ImmibisCore";
	public static final String MODID_COREMOD = "ImmibisCore_InstalledAsCoreMod";
	public static final String NAME = "Immibis Core";

	// 0 unused
	// 1 unused
	public static final int PACKET_TYPE_C2S_MULTIPART_DIG_START = 2;
	// 3 unused
	// 4 unused
	public static final int PACKET_TYPE_FRAGMENT = 5;
	public static final int PACKET_TYPE_C2S_BUTTON_PRESS = 6;
	


	public static final String CHANNEL = "ImmibisCore";

	public static IDAllocator idAllocator = new IDAllocator();
	public static NetworkingManager networkingManager = new NetworkingManager();
	public static ICrossModIC2 crossModIC2;
	public static ICrossModBC crossModBC;
	
	public static Logger LOGGER;
	static {
		FMLRelaunchLog.makeLog(MODID);
		LOGGER = Logger.getLogger(MODID);
	}
	
	public static java.util.Timer TIMER = new java.util.Timer("Immibis Core background task", true);

	public void preInit(FMLPreInitializationEvent evt) {
		
		APILocator.getNetManager().listen(this);

		FragmentSequence.init();
		MainThreadTaskQueue.init();
		
		if(Loader.isModLoaded("IC2"))
			crossModIC2 = new CrossModIC2_Impl();
		else
			crossModIC2 = new CrossModIC2_Default();
		
		crossModBC = new CrossModBC();
	}

	public void init(FMLInitializationEvent evt) {
		
		MultipartSystem.init();
		
		idAllocator.allocate(new IIDSet() {
			@Override
			public int getIDFor(String name, IDType type, int _default) {
				switch(type) {
				case TerrainBlock:
					Property property = Config.config.getTerrainBlock(Configuration.CATEGORY_BLOCK, name, _default, null);
					if(!property.wasRead())
						Config.save();
					return property.getInt(_default);
				case Block:
					property = Config.config.getBlock(name+".id", _default);
					if(!property.wasRead())
						Config.save();
					return property.getInt(_default);
				case Item:
					property = Config.config.get(Configuration.CATEGORY_ITEM, name, _default);
					if(!property.wasRead())
						Config.save();
					return property.getInt(_default);
				}
				return 0;
			}
		});
	}

	public void postInit(FMLPostInitializationEvent evt) {
		
	}
	
	public void serverStarting(FMLServerStartingEvent evt) {
		if(Config.getBoolean("enableTPSCommand", true))
			evt.registerServerCommand(new TPSCommand());
	}

	public static ImmibisCore instance;

	public ImmibisCore() {
		instance = this;
	}



	public static boolean areItemsEqual(ItemStack a, ItemStack b) {
		if(a == null && b == null)
			return true;
		if(a == null || b == null)
			return false;
		if(a.itemID != b.itemID)
			return false;
		if(a.getHasSubtypes() && a.getItemDamage() != b.getItemDamage())
			return false;
		if(a.stackTagCompound == null && b.stackTagCompound == null)
			return true;
		if(a.stackTagCompound == null || b.stackTagCompound == null)
			return false;
		return a.stackTagCompound.equals(b.stackTagCompound);
	}

	@Override
	public String getChannel() {
		return CHANNEL;
	}

	@Override
	public IPacket createS2CPacket(byte id) {
		if(id == PACKET_TYPE_FRAGMENT)
			return new PacketFragment();
		return null;
	}

	@Override
	public IPacket createC2SPacket(byte id) {
		if(id == PACKET_TYPE_C2S_BUTTON_PRESS)
			return new PacketButtonPress(0);
		if(id == PACKET_TYPE_C2S_MULTIPART_DIG_START)
			return new PacketMultipartDigStart();
		if(id == PACKET_TYPE_FRAGMENT)
			return new PacketFragment();
		return null;
	}

	static {
		((LaunchClassLoader)ImmibisCore.class.getClassLoader()).registerTransformer(MultiInterfaceClassTransformer.class.getName());
		((LaunchClassLoader)ImmibisCore.class.getClassLoader()).registerTransformer(TraitTransformer.class.getName());
		
		ITrait.knownInterfaces.put(IInventoryTrait.class, InventoryTraitImpl.class);
	}

	private static ILogAgent getClientLogAgent() {
		return Minecraft.getMinecraft().getLogAgent();
	}
	public static ILogAgent getLogAgent() {
		MinecraftServer sv = MinecraftServer.getServer();
		if(sv == null)
			return getClientLogAgent();
		return sv.getLogAgent();
	}

}
