/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.core.IPlugin;
import forestry.api.core.PluginInfo;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IMutation;
import forestry.apiculture.genetics.AlleleBeeSpecies;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.apiculture.genetics.JubilanceReqRes;
import forestry.apiculture.genetics.MutationEMC;
import forestry.core.config.Config;
import forestry.core.genetics.Allele;
import forestry.core.proxy.Proxies;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;

@PluginInfo(pluginID="EqEx2", name="Equivalent Exchange 2", author="SirSengir", url="http://forestry.sengir.net/", description="Compatibility plugin for Equivalent Exchange 2. Enables the Omega branch of bees. Requires Apiculture to be enabled.")
public class PluginEE
implements IPlugin {
    public IMutation darkenedA;
    public IMutation reddenedA;
    public IMutation omegaA;
    public ItemStack eeBlock1;
    public ItemStack eeBlock2;
    public Class eeRelay2Class;
    public Class eeRelay3Class;
    public Field eeRelay2EMCField;
    public Field eeRelay3EMCField;

    @Override
    public boolean isAvailable() {
        return Proxies.common.isModLoaded("mod_EE") && !Config.disableApiculture;
    }

    @Override
    public void postInit() {
        try {
            this.eeBlock1 = new ItemStack((Block)Class.forName("ee.EEBlock").getField("eeStone").get(null), 1, 8);
            this.eeBlock2 = new ItemStack((Block)Class.forName("ee.EEBlock").getField("eeStone").get(null), 1, 9);
            this.eeRelay2Class = Class.forName("ee.TileRelay2");
            this.eeRelay2EMCField = this.eeRelay2Class.getField("scaledEnergy");
            this.eeRelay3Class = Class.forName("ee.TileRelay3");
            this.eeRelay3EMCField = this.eeRelay3Class.getField("scaledEnergy");
        }
        catch (Exception ex) {
            Proxies.log.fine("Necessary block/classes from EE were not found");
            return;
        }
        JubilanceReqRes jubilanceProviderDarkened = new JubilanceReqRes(this.eeBlock1);
        JubilanceReqRes jubilanceProviderReddened = new JubilanceReqRes(this.eeBlock2);
        ((AlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele((String)"forestry.speciesDarkened")).jubilanceProvider = jubilanceProviderDarkened;
        ((AlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele((String)"forestry.speciesReddened")).jubilanceProvider = jubilanceProviderReddened;
        ((AlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele((String)"forestry.speciesOmega")).jubilanceProvider = jubilanceProviderReddened;
        this.darkenedA = new MutationEMC(Allele.speciesModest, Allele.speciesWintry, BeeTemplates.getDarkenedTemplate(), 100, this.eeBlock1, this.eeRelay2Class, this.eeRelay2EMCField, 139264);
        this.reddenedA = new MutationEMC(Allele.speciesDarkened, Allele.speciesTropical, BeeTemplates.getReddenedTemplate(), 100, this.eeBlock2, this.eeRelay3Class, this.eeRelay3EMCField, 466944);
        this.omegaA = new MutationEMC(Allele.speciesDarkened, Allele.speciesReddened, BeeTemplates.getOmegaTemplate(), 100, this.eeBlock2, this.eeRelay3Class, this.eeRelay3EMCField, 933888).restrictBiomeType(BiomeDictionary.Type.NETHER).restrictBiomeType(BiomeDictionary.Type.DESERT);
    }

    @Override
    public void preInit() {
    }

    @Override
    public void doInit() {
    }
}

