/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostalCarrier;
import forestry.api.mail.IPostalState;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import forestry.mail.EnumAddressee;
import forestry.mail.EnumDeliveryState;
import forestry.mail.POBox;
import forestry.mail.PostRegistry;
import forestry.plugins.PluginMail;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class PostalCarrier
implements IPostalCarrier {
    private String uid;
    private String iconID;
    private EnumAddressee type;

    public PostalCarrier(EnumAddressee type) {
        this.uid = type.toString().toLowerCase(Locale.ENGLISH);
        this.iconID = "mail/carrier." + this.uid;
        this.type = type;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    public String getName() {
        return StringUtil.localize("gui.addressee." + this.uid);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return TextureManager.getInstance().getDefault(this.iconID);
    }

    @Override
    public IPostalState deliverLetter(World world, IPostOffice office, String recipient, ItemStack letterstack, boolean doDeliver) {
        if (this.type == EnumAddressee.TRADER) {
            return this.handleTradeLetter(world, office, recipient, letterstack, doDeliver);
        }
        return this.storeInPOBox(world, office, recipient, letterstack, doDeliver);
    }

    private IPostalState handleTradeLetter(World world, IPostOffice office, String recipient, ItemStack letterstack, boolean doLodge) {
        IPostalState state = EnumDeliveryState.NOT_MAILABLE;
        ITradeStation trade = PostManager.postRegistry.getTradeStation(world, recipient);
        if (trade == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        state = trade.handleLetter(world, recipient, letterstack, doLodge);
        return state;
    }

    private EnumDeliveryState storeInPOBox(World world, IPostOffice office, String recipient, ItemStack letterstack, boolean doLodge) {
        POBox pobox = PostRegistry.getPOBox(world, recipient);
        if (pobox == null) {
            return EnumDeliveryState.NO_MAILBOX;
        }
        if (!pobox.storeLetter(letterstack.func_77946_l())) {
            return EnumDeliveryState.MAILBOX_FULL;
        }
        PluginMail.proxy.setPOBoxInfo(world, recipient, pobox.getPOBoxInfo());
        return EnumDeliveryState.OK;
    }
}

