/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Utils;
import forestry.lepidopterology.entities.AIButterflyBase;
import forestry.lepidopterology.entities.EntityButterfly;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public class AIButterflyInteract
extends AIButterflyBase {
    private ChunkCoordinates rest;
    private boolean canLayEgg = false;
    private boolean canPollinate = false;
    private boolean hasLayedEgg = false;
    private boolean hasPollinated = false;

    public AIButterflyInteract(EntityButterfly entity) {
        super(entity);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.entity.getState() != EntityButterfly.EnumButterflyState.RESTING) {
            return false;
        }
        this.rest = new ChunkCoordinates((int)this.entity.field_70165_t, (int)Math.floor(this.entity.field_70163_u) - 1, (int)this.entity.field_70161_v);
        if (this.entity.field_70170_p.func_72799_c(this.rest.field_71574_a, this.rest.field_71572_b, this.rest.field_71573_c)) {
            return false;
        }
        this.canLayEgg = this.canLayEgg();
        this.canPollinate = this.canPollinate();
        return this.canLayEgg || this.canPollinate;
    }

    private boolean canLayEgg() {
        if (this.entity.cooldownEgg > 0) {
            return false;
        }
        if (this.entity.getButterfly().getMate() == null) {
            return false;
        }
        TileEntity tile = this.entity.field_70170_p.func_72796_p(this.rest.field_71574_a, this.rest.field_71572_b, this.rest.field_71573_c);
        IButterflyNursery nursery = null;
        if (tile instanceof IButterflyNursery) {
            nursery = (IButterflyNursery)tile;
        } else {
            for (Map.Entry entry : AlleleManager.ersatzSpecimen.entrySet()) {
                if (((ItemStack)entry.getKey()).field_77993_c != this.entity.field_70170_p.func_72798_a(this.rest.field_71574_a, this.rest.field_71572_b, this.rest.field_71573_c)) continue;
                int meta = this.entity.field_70170_p.func_72805_g(this.rest.field_71574_a, this.rest.field_71572_b, this.rest.field_71573_c);
                if (((ItemStack)entry.getKey()).field_77993_c == Block.field_71952_K.field_71990_ca) {
                    meta &= 3;
                }
                if (((ItemStack)entry.getKey()).func_77960_j() != meta) continue;
                ((ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees")).setLeaves(this.entity.field_70170_p, (IIndividual)entry.getValue(), "", this.rest.field_71574_a, this.rest.field_71572_b, this.rest.field_71573_c);
                nursery = (IButterflyNursery)this.entity.field_70170_p.func_72796_p(this.rest.field_71574_a, this.rest.field_71572_b, this.rest.field_71573_c);
            }
        }
        if (nursery == null) {
            return false;
        }
        return nursery.canNurse(this.entity.getButterfly());
    }

    private boolean canPollinate() {
        if (this.entity.cooldownPollination > 0) {
            return false;
        }
        IPollinatable pollinatable = Utils.getOrCreatePollinatable("", this.entity.field_70170_p, this.rest.field_71574_a, this.rest.field_71572_b, this.rest.field_71573_c);
        if (pollinatable == null) {
            return false;
        }
        if (!this.entity.getButterfly().getGenome().getFlowerProvider().isAcceptedPollinatable(this.entity.field_70170_p, pollinatable)) {
            return false;
        }
        return this.entity.getPollen() == null || pollinatable.canMateWith(this.entity.getPollen());
    }

    public boolean func_75253_b() {
        return this.canLayEgg && !this.hasLayedEgg || this.canPollinate && !this.hasPollinated;
    }

    public void func_75249_e() {
    }

    public void func_75251_c() {
        this.hasLayedEgg = false;
        this.hasPollinated = false;
        this.canLayEgg = false;
        this.canPollinate = false;
        this.rest = null;
    }

    public void func_75246_d() {
        if (this.canLayEgg && !this.hasLayedEgg) {
            IButterflyNursery tile = (IButterflyNursery)this.entity.field_70170_p.func_72796_p(this.rest.field_71574_a, this.rest.field_71572_b, this.rest.field_71573_c);
            if (tile.canNurse(this.entity.getButterfly())) {
                tile.setCaterpillar(this.entity.getButterfly().spawnCaterpillar(tile));
                Proxies.log.finest("A butterfly '%s' laid an egg at %s/%s/%s.", this.entity.getButterfly().getIdent(), this.rest.field_71574_a, this.rest.field_71572_b, this.rest.field_71573_c);
                if (this.entity.func_70681_au().nextFloat() < 1.0f / (float)this.entity.getButterfly().getGenome().getFertility()) {
                    this.entity.func_70606_j(0.0f);
                }
            }
            this.hasLayedEgg = true;
            this.entity.cooldownEgg = 1000;
        }
        if (this.canPollinate && !this.hasPollinated) {
            IPollinatable pollinatable = (IPollinatable)this.entity.field_70170_p.func_72796_p(this.rest.field_71574_a, this.rest.field_71572_b, this.rest.field_71573_c);
            if (this.entity.getPollen() == null) {
                this.entity.setPollen(pollinatable.getPollen());
            } else if (pollinatable.canMateWith(this.entity.getPollen())) {
                pollinatable.mateWith(this.entity.getPollen());
                this.entity.setPollen(null);
            }
            this.hasPollinated = true;
            this.entity.cooldownPollination = 1000;
        }
    }
}

