/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.RainSubstrate;
import forestry.core.gadgets.Mill;
import forestry.core.gadgets.TileBase;
import forestry.core.proxy.Proxies;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public class MillRainmaker
extends Mill
implements ISpecialInventory {
    private int duration;
    private boolean reverse;

    public MillRainmaker() {
        this.speed = 0.01f;
    }

    @Override
    public String func_70303_b() {
        return "Rainmaker";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        if (!Proxies.common.isSimulating(player.field_70170_p)) {
            return;
        }
        if (player.field_71071_by.func_70448_g() == null) {
            return;
        }
        int usedItemId = player.field_71071_by.func_70448_g().field_77993_c;
        if (FuelManager.rainSubstrate.containsKey(player.field_71071_by.func_70448_g()) && this.charge == 0) {
            RainSubstrate substrate = (RainSubstrate)FuelManager.rainSubstrate.get(player.field_71071_by.func_70448_g());
            if (substrate.item.func_77969_a(player.field_71071_by.func_70448_g())) {
                this.addCharge(substrate);
                --player.field_71071_by.func_70448_g().field_77994_a;
            }
        }
        this.sendNetworkUpdate();
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.charge = nbttagcompound.func_74762_e("Charge");
        this.progress = nbttagcompound.func_74760_g("Progress");
        this.stage = nbttagcompound.func_74762_e("Stage");
        this.duration = nbttagcompound.func_74762_e("Duration");
        this.reverse = nbttagcompound.func_74767_n("Reverse");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("Charge", this.charge);
        nbttagcompound.func_74776_a("Progress", this.progress);
        nbttagcompound.func_74768_a("Stage", this.stage);
        nbttagcompound.func_74768_a("Duration", this.duration);
        nbttagcompound.func_74757_a("Reverse", this.reverse);
    }

    public void addCharge(RainSubstrate substrate) {
        this.charge = 1;
        this.speed = substrate.speed;
        this.duration = substrate.duration;
        this.reverse = substrate.reverse;
    }

    @Override
    public void activate() {
        if (Proxies.render.hasRendering()) {
            this.field_70331_k.func_72908_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, "ambient.weather.thunder", 4.0f, (1.0f + (this.field_70331_k.field_73012_v.nextFloat() - this.field_70331_k.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            float f = (float)this.field_70329_l + 0.5f;
            float f1 = (float)this.field_70330_m + 0.0f + this.field_70331_k.field_73012_v.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)this.field_70327_n + 0.5f;
            float f3 = 0.52f;
            float f4 = this.field_70331_k.field_73012_v.nextFloat() * 0.6f - 0.3f;
            Proxies.common.addEntityExplodeFX(this.field_70331_k, f - f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntityExplodeFX(this.field_70331_k, f + f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntityExplodeFX(this.field_70331_k, f + f4, f1, f2 - f3, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntityExplodeFX(this.field_70331_k, f + f4, f1, f2 + f3, 0.0f, 0.0f, 0.0f);
        }
        if (Proxies.common.isSimulating(this.field_70331_k)) {
            if (this.reverse) {
                this.field_70331_k.func_72912_H().func_76084_b(false);
            } else {
                this.field_70331_k.func_72912_H().func_76084_b(true);
                this.field_70331_k.func_72912_H().func_76080_g(this.duration);
            }
            this.charge = 0;
            this.duration = 0;
            this.reverse = false;
            this.sendNetworkUpdate();
        }
    }

    @Override
    public boolean workCycle() {
        return false;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (this.charge != 0) {
            return 0;
        }
        if (!FuelManager.rainSubstrate.containsKey(stack)) {
            return 0;
        }
        RainSubstrate substrate = (RainSubstrate)FuelManager.rainSubstrate.get(stack);
        if (!substrate.item.func_77969_a(stack)) {
            return 0;
        }
        if (doAdd) {
            this.addCharge(substrate);
        }
        return 1;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return null;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int var1) {
        return null;
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
    }

    public int func_70297_j_() {
        return 0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

