/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.core.INBTTagable;
import forestry.core.utils.Utils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemInventory
implements IInventory,
INBTTagable {
    public final Class itemClass;
    public boolean isItemInventory = false;
    public ItemStack parent;
    protected ItemStack[] inventoryStacks;

    protected ItemInventory(Class itemClass) {
        this.itemClass = itemClass;
    }

    public ItemInventory(Class itemClass, int slots) {
        this(itemClass);
        this.inventoryStacks = new ItemStack[slots];
    }

    public ItemInventory(Class itemClass, int size, ItemStack itemstack) {
        this(itemClass, size);
        this.parent = itemstack;
        this.isItemInventory = true;
        this.setUID(true);
        this.readFromNBT(itemstack.func_77978_p());
    }

    protected void setUID(boolean override) {
        if (this.parent.func_77978_p() == null) {
            this.parent.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbttagcompound = this.parent.func_77978_p();
        if (override || !nbttagcompound.func_74764_b("UID")) {
            nbttagcompound.func_74768_a("UID", Utils.getUID());
            this.parent.func_77982_d(nbttagcompound);
        }
    }

    public void onGuiSaved(EntityPlayer player) {
        this.parent = this.determineParentInInventory(player);
        if (this.parent != null) {
            this.save();
        }
    }

    public ItemStack determineParentInInventory(EntityPlayer player) {
        NBTTagCompound nbttagcompoundSlot;
        if (this.parent == null) {
            return null;
        }
        NBTTagCompound nbttagcompound = this.parent.func_77978_p();
        if (nbttagcompound == null) {
            return null;
        }
        int uid = nbttagcompound.func_74762_e("UID");
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            NBTTagCompound nbttagcompoundSlot2;
            if (player.field_71071_by.func_70301_a(i) == null || (nbttagcompoundSlot2 = player.field_71071_by.func_70301_a(i).func_77978_p()) == null || uid != nbttagcompoundSlot2.func_74762_e("UID")) continue;
            return player.field_71071_by.func_70301_a(i);
        }
        if (player.field_71071_by.func_70445_o() != null && (nbttagcompoundSlot = player.field_71071_by.func_70445_o().func_77978_p()) != null && uid == nbttagcompoundSlot.func_74762_e("UID")) {
            return player.field_71071_by.func_70445_o();
        }
        return null;
    }

    public boolean matchesUID(int otherId) {
        if (this.parent == null) {
            return false;
        }
        NBTTagCompound nbttagcompound = this.parent.func_77978_p();
        if (nbttagcompound == null) {
            return false;
        }
        int uid = nbttagcompound.func_74762_e("UID");
        return uid == otherId;
    }

    public void save() {
        NBTTagCompound nbttagcompound = this.parent.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
        }
        this.writeToNBT(nbttagcompound);
        this.parent.func_77982_d(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        if (nbttagcompound == null) {
            return;
        }
        if (nbttagcompound.func_74764_b("Items")) {
            NBTTagList nbttaglist = nbttagcompound.func_74761_m("Items");
            this.inventoryStacks = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
                byte byte0 = nbttagcompound1.func_74771_c("Slot");
                if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
                this.inventoryStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            if (this.inventoryStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventoryStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventoryStacks[i] == null) {
            return null;
        }
        if (this.inventoryStacks[i].field_77994_a <= j) {
            ItemStack product = this.inventoryStacks[i];
            this.inventoryStacks[i] = null;
            return product;
        }
        ItemStack product = this.inventoryStacks[i].func_77979_a(j);
        if (this.inventoryStacks[i].field_77994_a == 0) {
            this.inventoryStacks[i] = null;
        }
        return product;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventoryStacks[i] = itemstack;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventoryStacks[i];
    }

    public int func_70302_i_() {
        return this.inventoryStacks.length;
    }

    public String func_70303_b() {
        return "BeeBag";
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventoryStacks[slot] == null) {
            return null;
        }
        ItemStack toReturn = this.inventoryStacks[slot];
        this.inventoryStacks[slot] = null;
        return toReturn;
    }
}

