/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.triggers;

import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.render.TextureManager;
import forestry.core.utils.StringUtil;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;

public abstract class Trigger
implements ITrigger {
    private int id;
    private String uid;
    private String unlocalized;
    @SideOnly(value=Side.CLIENT)
    private Icon icon;

    public Trigger(int id, String uid) {
        this.id = id;
        this.uid = uid;
        this.unlocalized = "trigger." + uid;
        ActionManager.registerTrigger(this);
    }

    @Override
    public int getLegacyId() {
        return this.id;
    }

    @Override
    public String getUniqueTag() {
        return this.uid;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize(this.unlocalized);
    }

    @Override
    public boolean hasParameter() {
        return false;
    }

    @Override
    public ITriggerParameter createParameter() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister register) {
        this.icon = TextureManager.getInstance().registerTex(register, "triggers/" + this.uid);
    }
}

