/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.proxy.Proxies;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public class ForestryPacket {
    protected int id;
    protected String channel = "FOR";
    protected boolean isChunkDataPacket = false;

    public ForestryPacket() {
    }

    public ForestryPacket(int id) {
        this.id = id;
    }

    public Packet getPacket() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeByte(this.getID());
            this.writeData(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = this.channel;
        packet.field_73629_c = bytes.toByteArray();
        packet.field_73628_b = packet.field_73629_c.length;
        packet.field_73287_r = this.isChunkDataPacket;
        return packet;
    }

    public int getID() {
        return this.id;
    }

    protected ItemStack readItemStack(DataInputStream data) throws IOException {
        ItemStack itemstack = null;
        short itemID = data.readShort();
        if (itemID >= 0) {
            byte stackSize = data.readByte();
            short meta = data.readShort();
            itemstack = new ItemStack((int)itemID, (int)stackSize, (int)meta);
            if (Item.field_77698_e[itemID].func_77645_m() || Proxies.common.needsTagCompoundSynched(Item.field_77698_e[itemID])) {
                itemstack.field_77990_d = this.readNBTTagCompound(data);
            }
        }
        return itemstack;
    }

    protected void writeItemStack(ItemStack itemstack, DataOutputStream data) throws IOException {
        if (itemstack == null) {
            data.writeShort(-1);
        } else {
            data.writeShort(itemstack.field_77993_c);
            data.writeByte(itemstack.field_77994_a);
            data.writeShort(itemstack.func_77960_j());
            if (itemstack.func_77973_b().func_77645_m() || Proxies.common.needsTagCompoundSynched(itemstack.func_77973_b())) {
                this.writeNBTTagCompound(itemstack.field_77990_d, data);
            }
        }
    }

    protected NBTTagCompound readNBTTagCompound(DataInputStream data) throws IOException {
        short length = data.readShort();
        if (length < 0) {
            return null;
        }
        byte[] compressed = new byte[length];
        data.readFully(compressed);
        return CompressedStreamTools.func_74792_a((byte[])compressed);
    }

    protected void writeNBTTagCompound(NBTTagCompound nbttagcompound, DataOutputStream data) throws IOException {
        if (nbttagcompound == null) {
            data.writeShort(-1);
        } else {
            byte[] compressed = CompressedStreamTools.func_74798_a((NBTTagCompound)nbttagcompound);
            data.writeShort((short)compressed.length);
            data.write(compressed);
        }
    }

    public void writeData(DataOutputStream data) throws IOException {
    }

    public void readData(DataInputStream data) throws IOException {
    }
}

