/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import forestry.core.TemperatureState;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.IPowerHandler;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.TankSlot;
import forestry.plugins.PluginBuildCraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;

public abstract class Engine
extends TileBase
implements IPowerHandler,
IPipeConnection,
IPowerEmitter {
    public boolean isActive = false;
    public int stagePiston = 0;
    public float pistonSpeedServer = 0.0f;
    protected int currentOutput = 0;
    public final int maxEnergy;
    public final int maxEnergyExtracted;
    public float storedEnergy;
    public int heat;
    protected final int maxHeat;
    protected boolean forceCooldown = false;
    public float progress;
    private PowerHandler powerProvider;

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(3, 1, 0);
        payload.intPayload[0] = this.isActive ? 1 : 0;
        payload.intPayload[1] = (int)this.storedEnergy;
        payload.intPayload[2] = this.heat;
        payload.floatPayload[0] = this.pistonSpeedServer;
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        this.isActive = payload.intPayload[0] > 0;
        this.storedEnergy = payload.intPayload[1];
        this.heat = payload.intPayload[2];
        this.pistonSpeedServer = payload.floatPayload[0];
    }

    public Engine(int maxHeat, int maxEnergy, int maxEnergyExtracted) {
        this.maxHeat = maxHeat;
        this.maxEnergy = maxEnergy;
        this.maxEnergyExtracted = maxEnergyExtracted;
        this.powerProvider = new PowerHandler(this, PowerHandler.Type.ENGINE);
        this.powerProvider.configure(10.0f, 200.0f, 10.0f, 100000.0f);
    }

    protected ItemStack replenishByContainer(ItemStack inventoryStack, FluidContainerRegistry.FluidContainerData container, TankSlot tank) {
        if (container == null) {
            return inventoryStack;
        }
        if (tank.fill(container.fluid, false) >= container.fluid.amount) {
            tank.fill(container.fluid, true);
            if (container.filledContainer != null && container.filledContainer.func_77973_b().func_77634_r()) {
                inventoryStack = container.emptyContainer.func_77946_l();
            } else {
                --inventoryStack.field_77994_a;
            }
        }
        return inventoryStack;
    }

    @Override
    public void rotateAfterPlacement(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemstack) {
        this.rotateEngine();
    }

    public void addEnergy(float addition) {
        this.storedEnergy += addition;
        if (this.storedEnergy > (float)this.maxEnergy) {
            this.storedEnergy = this.maxEnergy;
        }
    }

    public float extractEnergy(float min, float max, boolean doExtract) {
        float extracted;
        float ceiling;
        if (this.storedEnergy < min) {
            return 0.0f;
        }
        float f = ceiling = max > (float)this.maxEnergyExtracted ? (float)this.maxEnergyExtracted : max;
        if (this.storedEnergy >= ceiling) {
            extracted = ceiling;
            if (doExtract) {
                this.storedEnergy -= ceiling;
            }
        } else {
            extracted = this.storedEnergy;
            if (doExtract) {
                this.storedEnergy = 0.0f;
            }
        }
        return extracted;
    }

    protected void addHeat(int i) {
        this.heat += i;
        if (this.heat > this.maxHeat) {
            this.heat = this.maxHeat;
        }
    }

    public abstract int dissipateHeat();

    public abstract int generateHeat();

    public int maxEnergyReceived() {
        return 200;
    }

    public boolean mayBurn() {
        return !this.forceCooldown;
    }

    public abstract void burn();

    @Override
    public void updateClientSide() {
        if (this.stagePiston != 0) {
            this.progress += this.pistonSpeedServer;
            if (this.progress > 1.0f) {
                this.stagePiston = 0;
                this.progress = 0.0f;
            }
        } else if (this.isActive) {
            this.stagePiston = 1;
        }
    }

    @Override
    public void updateServerSide() {
        TemperatureState energyState = this.getTemperatureState();
        if (energyState == TemperatureState.MELTING && this.heat > 0) {
            this.forceCooldown = true;
        } else if (this.forceCooldown && this.heat <= 0) {
            this.forceCooldown = false;
        }
        Position posTarget = new Position(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getOrientation());
        posTarget.moveForwards(1.0);
        TileEntity tile = this.field_70331_k.func_72796_p((int)posTarget.x, (int)posTarget.y, (int)posTarget.z);
        float newPistonSpeed = this.getPistonSpeed();
        if (newPistonSpeed != this.pistonSpeedServer) {
            this.pistonSpeedServer = newPistonSpeed;
            this.sendNetworkUpdate();
        }
        if (this.stagePiston != 0) {
            this.progress += this.pistonSpeedServer;
            if ((double)this.progress > 0.5 && this.stagePiston == 1) {
                IPowerReceptor receptor;
                float extractedEnergy;
                this.stagePiston = 2;
                if (BlockUtil.isPoweredTile(this.getOrientation().getOpposite(), tile) && (extractedEnergy = this.extractEnergy((receptor = (IPowerReceptor)tile).getPowerReceiver(this.getOrientation().getOpposite()).getMinEnergyReceived(), receptor.getPowerReceiver(this.getOrientation().getOpposite()).getMaxEnergyReceived(), true)) > 0.0f) {
                    PluginBuildCraft.instance.invokeReceiveEnergyMethod(PowerHandler.Type.ENGINE, receptor.getPowerReceiver(this.getOrientation().getOpposite()), extractedEnergy, this.getOrientation().getOpposite());
                }
            } else if (this.progress >= 1.0f) {
                this.progress = 0.0f;
                this.stagePiston = 0;
            }
        } else if (this.canPowerTo(tile)) {
            IPowerReceptor receptor = (IPowerReceptor)tile;
            if (this.extractEnergy(receptor.getPowerReceiver(this.getOrientation().getOpposite()).getMinEnergyReceived(), receptor.getPowerReceiver(this.getOrientation().getOpposite()).getMaxEnergyReceived(), false) > 0.0f) {
                this.stagePiston = 1;
                this.setActive(true);
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        this.dissipateHeat();
        this.generateHeat();
        if (this.mayBurn()) {
            this.burn();
        } else {
            this.extractEnergy(0.0f, 2.0f, true);
        }
    }

    private boolean canPowerTo(TileEntity tile) {
        return this.isActivated() && BlockUtil.isPoweredTile(this.getOrientation().getOpposite(), tile);
    }

    private void setActive(boolean isActive) {
        if (this.isActive == isActive) {
            return;
        }
        this.isActive = isActive;
        this.sendNetworkUpdate();
    }

    public void rotateEngine() {
        for (int i = this.getOrientation().ordinal() + 1; i <= this.getOrientation().ordinal() + 6; ++i) {
            ForgeDirection orient = ForgeDirection.values()[i % 6];
            Position pos = new Position(this.field_70329_l, this.field_70330_m, this.field_70327_n, orient);
            pos.moveForwards(1.0);
            TileEntity tile = this.field_70331_k.func_72796_p((int)pos.x, (int)pos.y, (int)pos.z);
            if (!BlockUtil.isPoweredTile(this.getOrientation().getOpposite(), tile)) continue;
            this.setOrientation(orient);
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            break;
        }
    }

    protected double getHeatLevel() {
        return (double)this.heat / (double)this.maxHeat;
    }

    public abstract boolean isBurning();

    public int getBurnTimeRemainingScaled(int i) {
        return 0;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public int getCurrentOutput() {
        if (this.isBurning() && this.isActivated()) {
            return this.currentOutput;
        }
        return 0;
    }

    public float getEnergyStored() {
        return this.storedEnergy;
    }

    public int getHeat() {
        return this.heat;
    }

    public TemperatureState getTemperatureState() {
        double scaledHeat = (double)this.heat / (double)this.maxHeat;
        if (scaledHeat < 0.2) {
            return TemperatureState.COOL;
        }
        if (scaledHeat < 0.45) {
            return TemperatureState.WARMED_UP;
        }
        if (scaledHeat < 0.65) {
            return TemperatureState.OPERATING_TEMPERATURE;
        }
        if (scaledHeat < 0.85) {
            return TemperatureState.RUNNING_HOT;
        }
        if (scaledHeat < 1.0) {
            return TemperatureState.OVERHEATING;
        }
        return TemperatureState.MELTING;
    }

    public float getPistonSpeed() {
        switch (this.getTemperatureState()) {
            case COOL: {
                return 0.03f;
            }
            case WARMED_UP: {
                return 0.04f;
            }
            case OPERATING_TEMPERATURE: {
                return 0.05f;
            }
            case RUNNING_HOT: {
                return 0.06f;
            }
            case OVERHEATING: {
                return 0.07f;
            }
            case MELTING: {
                return 0.08f;
            }
        }
        return 0.0f;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.heat = nbttagcompound.func_74762_e("EngineHeat");
        this.storedEnergy = nbttagcompound.func_74764_b("EngineStoredEnergy") ? (float)nbttagcompound.func_74762_e("EngineStoredEnergy") : nbttagcompound.func_74760_g("EngineStored");
        this.progress = nbttagcompound.func_74760_g("EngineProgress");
        this.forceCooldown = nbttagcompound.func_74767_n("ForceCooldown");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("EngineHeat", this.heat);
        nbttagcompound.func_74776_a("EngineStored", this.storedEnergy);
        nbttagcompound.func_74776_a("EngineProgress", this.progress);
        nbttagcompound.func_74757_a("ForceCooldown", this.forceCooldown);
    }

    public abstract void getGUINetworkData(int var1, int var2);

    public abstract void sendGUINetworkData(Container var1, ICrafting var2);

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerProvider.getPowerReceiver();
    }

    @Override
    public PowerHandler getPowerHandler() {
        return this.powerProvider;
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (!Proxies.common.isSimulating(this.field_70331_k)) {
            return;
        }
        this.addEnergy((int)(PluginBuildCraft.instance.invokeUseEnergyMethod(workProvider, 1.0f, this.maxEnergyReceived(), true) * 0.95f));
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        if (type == IPipeTile.PipeType.POWER) {
            return IPipeConnection.ConnectOverride.DEFAULT;
        }
        if (with == this.getOrientation()) {
            return IPipeConnection.ConnectOverride.DISCONNECT;
        }
        return IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    public boolean canEmitPowerFrom(ForgeDirection side) {
        return side == this.getOrientation();
    }
}

