/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.core.ForestryAPI;
import forestry.api.core.IGameMode;
import forestry.core.config.Config;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.config.Property;
import forestry.core.proxy.Proxies;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class GameMode
implements IGameMode {
    private String identifier = "EASY";
    private String category;
    private HashMap booleanSettings = new HashMap();
    private HashMap integerSettings = new HashMap();
    private HashMap floatSettings = new HashMap();
    private HashMap stackSettings = new HashMap();
    private static final float ENERGY_DEMAND_MODIFIER = 1.0f;
    private static final int FARM_FERTILIZER_VALUE = 2000;
    private ItemStack recipeFertilizerOutputApatite = new ItemStack(ForestryItem.fertilizerCompound, 8);
    private ItemStack recipeFertilizerOutputAsh = new ItemStack(ForestryItem.fertilizerCompound, 16);
    private ItemStack recipeCompostOutputWheat = new ItemStack(ForestryItem.fertilizerBio, 4);
    private ItemStack recipeCompostOutputAsh = new ItemStack(ForestryItem.fertilizerBio, 1);
    private ItemStack recipeHumusOutputFertilizer = new ItemStack(ForestryBlock.soil, 8, 0);
    private ItemStack recipeHumusOutputCompost = new ItemStack(ForestryBlock.soil, 8, 0);
    private ItemStack recipeBogEarthOutputBucket = new ItemStack(ForestryBlock.soil, 6, 1);
    private ItemStack recipeBogEarthOutputCans = new ItemStack(ForestryBlock.soil, 8, 1);
    private ItemStack recipeCanOutput = new ItemStack(ForestryItem.canEmpty, 12);
    private ItemStack recipeCapsuleOutput = new ItemStack(ForestryItem.waxCapsule, 4);
    private ItemStack recipeRefractoryOutput = new ItemStack(ForestryItem.refractoryEmpty, 4);
    private static final int FERMENTATION_DURATION_FERTILIZER = 200;
    private static final int FERMENTATION_DURATION_COMPOST = 250;
    private static final int FERMENTED_CYCLE_FERTILIZER = 56;
    private static final int FERMENTED_CYCLE_COMPOST = 48;
    private static final int FERMENTED_SAPLING = 250;
    private static final int FERMENTED_CACTI = 50;
    private static final int FERMENTED_WHEAT = 50;
    private static final int FERMENTED_CANE = 50;
    private static final int FERMENTED_MUSHROOM = 50;
    private static final int SQUEEZED_LIQUID_SEED = 10;
    private static final int SQUEEZED_LIQUID_APPLE = 200;
    private static final int SQUEEZED_MULCH_APPLE = 20;

    public static IGameMode getGameMode() {
        if (ForestryAPI.activeMode == null) {
            ForestryAPI.activeMode = new GameMode(Config.gameMode);
        }
        return ForestryAPI.activeMode;
    }

    public GameMode(String identifier) {
        this.identifier = identifier;
        this.category = "gamemodes/" + identifier;
        Configuration config = Config.config;
        this.initSetting("energy.demand.modifier", 1.0f, -1.0f, "modifies the energy required to activate machines, as well as the max amount of energy stored and accepted.");
        this.initSetting("farms.fertilizer.value", 2000, -1, "modifies the time a piece of fertilizer lasts in a farm.");
        this.initSetting("recipe.output.fertilizer.apatite", this.recipeFertilizerOutputApatite, "amount of fertilizer yielded by the recipe using apatite.");
        this.initSetting("recipe.output.fertilizer.ash", this.recipeFertilizerOutputAsh, "amount of fertilizer yielded by the recipe using ash.");
        this.initSetting("recipe.output.compost.wheat", this.recipeCompostOutputWheat, "amount of compost yielded by the recipe using wheat.");
        this.initSetting("recipe.output.compost.ash", this.recipeCompostOutputAsh, "amount of compost yielded by the recipe using ash.");
        this.initSetting("recipe.output.humus.fertilizer", this.recipeHumusOutputFertilizer, "amount of humus yielded by the recipe using fertilizer.");
        this.initSetting("recipe.output.humus.compost", this.recipeHumusOutputCompost, "amount of humus yielded by the recipe using compost.");
        this.initSetting("recipe.output.bogearth.bucket", this.recipeBogEarthOutputBucket, "amount of bog earth yielded by the recipe using buckets.");
        this.initSetting("recipe.output.bogearth.can", this.recipeBogEarthOutputCans, "amount of bog earth yielded by the recipes using cans, cells or capsules.");
        this.initSetting("recipe.output.can", this.recipeCanOutput, "amount yielded by the recipe for tin cans.");
        this.initSetting("recipe.output.capsule", this.recipeCapsuleOutput, "amount yielded by the recipe for wax capsules.");
        this.initSetting("recipe.output.refractory", this.recipeRefractoryOutput, "amount yielded by the recipe for refractory capsules.");
        this.initSetting("fermenter.cycles.fertilizer", 200, -1, "modifies the amount of cycles fertilizer can keep a fermenter going.");
        this.initSetting("fermenter.cycles.compost", 250, -1, "modifies the amount of cycles compost can keep a fermenter going.");
        this.initSetting("fermenter.value.fertilizer", 56, -1, "modifies the amount of biomass per cycle a fermenter will produce using fertilizer.");
        this.initSetting("fermenter.value.compost", 48, -1, "modifies the amount of biomass per cycle a fermenter will produce using compost.");
        this.initSetting("fermenter.yield.sapling", 250, 2000, "modifies the base amount of biomass a sapling will yield in a fermenter, affected by sappiness trait.");
        this.initSetting("fermenter.yield.cactus", 50, 400, "modifies the amount of biomass a piece of cactus will yield in a fermenter.");
        this.initSetting("fermenter.yield.wheat", 50, 400, "modifies the amount of biomass a piece of wheat will yield in a fermenter.");
        this.initSetting("fermenter.yield.cane", 50, 400, "modifies the amount of biomass a piece of sugar cane will yield in a fermenter.");
        this.initSetting("fermenter.yield.mushroom", 50, 400, "modifies the amount of biomass a mushroom will yield in a fermenter.");
        this.initSetting("squeezer.liquid.seed", 10, 80, "modifies the amount of seed oil squeezed from a single seed. other sources are based off this.");
        this.initSetting("squeezer.liquid.apple", 200, 1600, "modifies the amount of juice squeezed from a single apple. other sources are based off this.");
        this.initSetting("squeezer.mulch.apple", 20, 160, "modifies the chance of mulch per squeezed apple.");
        this.initSetting("energy.engine.clockwork", true, "set to false to disable the clockwork engine.");
        config.save();
    }

    private void initSetting(String ident, ItemStack def, String comment) {
        Property property = Config.config.get(ident, this.category, def.field_77994_a);
        property.Comment = comment;
        ItemStack changed = def.func_77946_l();
        changed.field_77994_a = Integer.parseInt(property.Value);
        this.stackSettings.put(ident, changed);
    }

    private void initSetting(String ident, int def, int max, String comment) {
        Property property = Config.config.get(ident, this.category, def);
        if (max < 0) {
            property.Comment = comment;
            this.integerSettings.put(ident, Integer.parseInt(property.Value));
        } else {
            property.Comment = comment + " (max: " + max + ")";
            this.integerSettings.put(ident, Math.min(Integer.parseInt(property.Value), max));
        }
        Config.config.set(ident, this.category, (Integer)this.integerSettings.get(ident));
    }

    private void initSetting(String ident, float def, float max, String comment) {
        Property property = Config.config.get(ident, this.category, def);
        if (max < 0.0f) {
            property.Comment = comment;
            this.floatSettings.put(ident, Float.valueOf(Float.parseFloat(property.Value)));
        } else {
            property.Comment = comment + " (max: " + max + ")";
            this.floatSettings.put(ident, Float.valueOf(Math.min(Float.parseFloat(property.Value), max)));
        }
        Config.config.set(ident, this.category, ((Float)this.floatSettings.get(ident)).floatValue());
    }

    private void initSetting(String ident, boolean def, String comment) {
        Property property = Config.config.get(ident, this.category, def);
        property.Comment = comment;
        this.booleanSettings.put(ident, Boolean.parseBoolean(property.Value));
        Config.config.set(ident, this.category, (Boolean)this.booleanSettings.get(ident));
    }

    @Override
    public int getIntegerSetting(String ident) {
        if (this.integerSettings.containsKey(ident)) {
            return (Integer)this.integerSettings.get(ident);
        }
        Proxies.log.warning("No such setting: " + ident);
        return -1;
    }

    @Override
    public float getFloatSetting(String ident) {
        if (this.floatSettings.containsKey(ident)) {
            return ((Float)this.floatSettings.get(ident)).floatValue();
        }
        Proxies.log.warning("No such setting: " + ident);
        return -1.0f;
    }

    @Override
    public boolean getBooleanSetting(String ident) {
        if (this.booleanSettings.containsKey(ident)) {
            return (Boolean)this.booleanSettings.get(ident);
        }
        Proxies.log.warning("No such setting: " + ident);
        return false;
    }

    @Override
    public ItemStack getStackSetting(String ident) {
        if (this.stackSettings.containsKey(ident)) {
            return (ItemStack)this.stackSettings.get(ident);
        }
        Proxies.log.warning("No such setting: " + ident);
        return new ItemStack(Item.field_77706_j, 1);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }
}

