/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingMode;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import net.minecraft.world.World;

public class BeekeepingMode
implements IBeekeepingMode {
    public static IBeekeepingMode easy = new BeekeepingMode("EASY", 2.0f, 1.0f, 1.0f, false, false);
    public static IBeekeepingMode normal = new BeekeepingMode("NORMAL", 1.0f, 1.0f, 1.0f, false, true);
    public static IBeekeepingMode hard = new BeekeepingMode("HARD", 0.75f, 1.5f, 1.0f, false, true);
    public static IBeekeepingMode hardcore = new BeekeepingMode("HARDCORE", 0.5f, 5.0f, 0.8f, true, true);
    public static IBeekeepingMode insane = new BeekeepingMode("INSANE", 0.2f, 10.0f, 0.6f, true, true);
    final Random rand = new Random();
    final String name;
    final float mutationModifier;
    final float lifespanModifier;
    final float speedModifier;
    final boolean reducesFertility;
    final boolean canFatigue;

    public BeekeepingMode(String name, float mutationModifier, float lifespanModifier, float speedModifier, boolean reducesFertility, boolean canFatigue) {
        this.name = name;
        this.mutationModifier = mutationModifier;
        this.lifespanModifier = lifespanModifier;
        this.speedModifier = speedModifier;
        this.reducesFertility = reducesFertility;
        this.canFatigue = canFatigue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ArrayList getDescription() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("beemode." + this.name.toLowerCase(Locale.ENGLISH) + ".desc");
        return ret;
    }

    @Override
    public float getWearModifier() {
        return 1.0f;
    }

    @Override
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.mutationModifier;
    }

    @Override
    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.lifespanModifier;
    }

    @Override
    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return this.speedModifier;
    }

    @Override
    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return 1.0f;
    }

    @Override
    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return 1.0f;
    }

    @Override
    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return 1.0f;
    }

    @Override
    public int getFinalFertility(IBee queen, World world, int x, int y, int z) {
        int toCreate = queen.getGenome().getFertility();
        if (this.reducesFertility) {
            toCreate = new Random().nextInt(toCreate);
        }
        return toCreate;
    }

    @Override
    public boolean isFatigued(IBee queen, IBeeHousing housing) {
        if (!this.canFatigue) {
            return false;
        }
        if (queen.isNatural()) {
            return false;
        }
        return this.rand.nextFloat() < 0.02f * housing.getGeneticDecay(queen.getGenome(), 1.0f);
    }

    @Override
    public boolean isOverworked(IBee queen, IBeeHousing housing) {
        float productionModifier = housing.getProductionModifier(queen.getGenome(), 1.0f);
        return productionModifier > 16.0f && (double)(housing.getWorld().field_73012_v.nextFloat() * 100.0f) < 0.01 * (double)(productionModifier * productionModifier - 100.0f);
    }

    @Override
    public boolean isDegenerating(IBee queen, IBee offspring, IBeeHousing housing) {
        float mutationModifier = housing.getMutationModifier(queen.getGenome(), queen.getMate(), 1.0f);
        return mutationModifier > 10.0f && (double)(housing.getWorld().field_73012_v.nextFloat() * 100.0f) < 0.4 * (double)(mutationModifier * mutationModifier - 100.0f);
    }

    @Override
    public boolean isNaturalOffspring(IBee queen) {
        return queen.isNatural();
    }

    @Override
    public boolean mayMultiplyPrincess(IBee queen) {
        return true;
    }

    @Override
    public boolean isSealed() {
        return false;
    }

    @Override
    public boolean isSelfLighted() {
        return false;
    }

    @Override
    public boolean isSunlightSimulated() {
        return false;
    }

    @Override
    public boolean isHellish() {
        return false;
    }
}

