/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.core.network.PacketPayload;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileAlvearyClimatiser
extends TileAlveary
implements IPowerReceptor {
    PowerHandler powerProvider;
    ClimateControl climateControl;
    private int transferTime = 0;
    private int animationDelay = 0;
    private int textureOff;
    private int textureOn;

    public TileAlvearyClimatiser(ClimateControl control, int textureOff, int textureOn, int componentBlockMeta) {
        super(componentBlockMeta);
        this.climateControl = control;
        this.powerProvider = new PowerHandler(this, PowerHandler.Type.MACHINE);
        this.powerProvider.configure(10.0f, 100.0f, 25.0f, 200.0f);
        this.textureOff = textureOff;
        this.textureOn = textureOn;
    }

    @Override
    public void openGui(EntityPlayer player) {
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (this.powerProvider != null) {
            this.powerProvider.update();
        }
        if (!this.hasMaster()) {
            return;
        }
        if (this.transferTime > 0) {
            --this.transferTime;
            IAlvearyComponent component = (IAlvearyComponent)this.getCentralTE();
            if (component != null) {
                component.addTemperatureChange(this.climateControl.changePerTransfer, this.climateControl.boundaryDown, this.climateControl.boundaryUp);
            }
        }
        if (this.animationDelay > 0) {
            --this.animationDelay;
            if (this.animationDelay <= 0) {
                this.sendNetworkUpdate();
            }
        }
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    public int getBlockTexture(int side, int metadata) {
        if (this.animationDelay > 0) {
            return this.textureOn;
        }
        return this.textureOff;
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (!this.hasMaster()) {
            return;
        }
        if (this.powerProvider.useEnergy(this.powerProvider.getActivationEnergy(), this.powerProvider.getEnergyStored(), false) < this.powerProvider.getActivationEnergy()) {
            return;
        }
        this.transferTime = Math.round(this.powerProvider.useEnergy(this.powerProvider.getActivationEnergy(), this.powerProvider.getEnergyStored(), true));
        if (this.animationDelay <= 0) {
            this.animationDelay = 100;
            this.sendNetworkUpdate();
        } else {
            this.animationDelay = 100;
        }
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerProvider.getPowerReceiver();
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.powerProvider.readFromNBT(nbttagcompound);
        this.transferTime = nbttagcompound.func_74762_e("Heating");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        this.powerProvider.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("Heating", this.transferTime);
    }

    @Override
    public String func_70303_b() {
        return "tile.alveary.climatiser";
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        this.animationDelay = payload.shortPayload[0];
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(0, 1);
        payload.shortPayload[0] = (short)this.animationDelay;
        return payload;
    }

    public static class ClimateControl {
        final float changePerTransfer;
        final float boundaryUp;
        final float boundaryDown;

        public ClimateControl(float changePerTransfer, float boundaryDown, float boundaryUp) {
            this.changePerTransfer = changePerTransfer;
            this.boundaryDown = boundaryDown;
            this.boundaryUp = boundaryUp;
        }
    }
}

