/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IHiveDrop;
import forestry.api.core.Tabs;
import forestry.apiculture.MaterialBeehive;
import forestry.apiculture.gadgets.TileSwarm;
import forestry.core.render.TextureManager;
import forestry.core.utils.StackUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class BlockBeehives
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private Icon[] icons;

    public BlockBeehives(int i) {
        super(i, (Material)new MaterialBeehive(true));
        this.func_71900_a(0.8f);
        this.func_71848_c(1.0f);
        this.func_71849_a(Tabs.tabApiculture);
    }

    public TileEntity func_72274_a(World world) {
        return new TileSwarm();
    }

    public boolean canDragonDestroy(World world, int x, int y, int z) {
        return false;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileSwarm swarm;
        TileEntity tile;
        if (this.canHarvestBlock(player, world.func_72805_g(x, y, z)) && (tile = world.func_72796_p(x, y, z)) instanceof TileSwarm && (swarm = (TileSwarm)tile).containsBees()) {
            for (ItemStack beeStack : swarm.contained.getStacks()) {
                if (beeStack == null) continue;
                StackUtils.dropItemStackAsEntity(beeStack, world, x, y, z);
            }
        }
        return world.func_72832_d(x, y, z, 0, 0, 3);
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (metadata == 0) {
            ret.add(new ItemStack((Block)this));
            return ret;
        }
        ArrayList dropList = BeeManager.hiveDrops[metadata - 1];
        Collections.shuffle(dropList);
        int tries = 0;
        boolean hasPrincess = false;
        block0: while (tries <= 10 && !hasPrincess) {
            ++tries;
            for (IHiveDrop drop : dropList) {
                if (world.field_73012_v.nextInt(100) >= drop.getChance(world, x, y, z)) continue;
                ret.add(drop.getPrincess(world, x, y, z, fortune));
                hasPrincess = true;
                continue block0;
            }
        }
        for (IHiveDrop drop : dropList) {
            if (world.field_73012_v.nextInt(100) >= drop.getChance(world, x, y, z)) continue;
            ret.addAll(drop.getDrones(world, x, y, z, fortune));
            break;
        }
        for (IHiveDrop drop : dropList) {
            if (world.field_73012_v.nextInt(100) >= drop.getChance(world, x, y, z)) continue;
            ret.addAll(drop.getAdditional(world, x, y, z, fortune));
            break;
        }
        return ret;
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(new ItemStack((Block)this, 1, 1));
        itemList.add(new ItemStack((Block)this, 1, 2));
        itemList.add(new ItemStack((Block)this, 1, 3));
        itemList.add(new ItemStack((Block)this, 1, 4));
        itemList.add(new ItemStack((Block)this, 1, 6));
        itemList.add(new ItemStack((Block)this, 1, 7));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        this.icons = new Icon[18];
        for (int i = 1; i < 9; ++i) {
            this.icons[i * 2] = TextureManager.getInstance().registerTex(register, "beehives/beehive." + i + ".top");
            this.icons[i * 2 + 1] = TextureManager.getInstance().registerTex(register, "beehives/beehive." + i + ".side");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int i, int j) {
        if (i == 0 || i == 1) {
            if (j * 2 < this.icons.length && this.icons[j * 2] != null) {
                return this.icons[j * 2];
            }
            return this.icons[2];
        }
        if (j * 2 + 1 < this.icons.length && this.icons[j * 2 + 1] != null) {
            return this.icons[j * 2 + 1];
        }
        return this.icons[3];
    }
}

