/*
 * Decompiled with CFR 0.152.
 */
package forestry;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import forestry.api.fuels.FuelManager;
import forestry.core.ForestryCore;
import forestry.core.network.PacketHandler;
import forestry.core.proxy.Proxies;
import forestry.core.utils.FluidStackMap;
import forestry.core.utils.ItemStackMap;

@Mod(modid="Forestry", name="Forestry", version="2.3.0.1_ic2.ex", dependencies="after:ExtrabiomesXL;after:BiomesOPlenty;after:IC2", certificateFingerprint="862700d0712182f612efd419ad296f9ed482ec1d")
@NetworkMod(channels={"FOR"}, clientSideRequired=true, serverSideRequired=true, packetHandler=PacketHandler.class)
public class Forestry {
    @SidedProxy(clientSide="forestry.core.ForestryClient", serverSide="forestry.core.ForestryCore")
    public static ForestryCore core = new ForestryCore();

    public Forestry() {
        FuelManager.fermenterFuel = new ItemStackMap();
        FuelManager.moistenerResource = new ItemStackMap();
        FuelManager.rainSubstrate = new ItemStackMap();
        FuelManager.bronzeEngineFuel = new FluidStackMap();
        FuelManager.copperEngineFuel = new ItemStackMap();
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        core.preInit(event.getSourceFile(), this);
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        core.init(this);
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        core.postInit();
    }

    @Mod.ServerStarting
    public void serverStarting(FMLServerStartingEvent event) {
        core.serverStarting(event.getServer());
    }

    @Mod.FingerprintWarning
    public void fingerprintWarning(FMLFingerprintViolationEvent event) {
        Proxies.log.info("Fingerprint of the mod jar is invalid. The jar file was tampered with.");
        FMLInterModComms.sendMessage((String)"Railcraft", (String)"securityViolation", (String)"Fingerprint of jar file did not match.");
        FMLInterModComms.sendMessage((String)"Thaumcraft", (String)"securityViolation", (String)"Fingerprint of jar file did not match.");
        FMLInterModComms.sendMessage((String)"IC2", (String)"securityViolation", (String)"Fingerprint of jar file did not match.");
    }

    @Mod.IMCCallback
    public void processIMCMessages(FMLInterModComms.IMCEvent event) {
        core.processIMCMessages(event.getMessages());
    }
}

