/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.liquid;

import codechicken.core.asm.InterfaceDependancies;
import codechicken.core.fluid.FluidUtils;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.TileFrequencyOwner;
import codechicken.enderstorage.storage.liquid.EnderLiquidStorage;
import codechicken.enderstorage.storage.liquid.TankSynchroniser;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.api.tileentity.IReconfigurableFacing;

@InterfaceDependancies
public class TileEnderTank
extends TileFrequencyOwner
implements IFluidHandler,
IReconfigurableFacing {
    private static Cuboid6[] selectionBoxes = new Cuboid6[4];
    public static Transformation[] buttonT = new Transformation[3];
    public int rotation;
    public EnderTankState liquid_state = new EnderTankState();
    public PressureState pressure_state = new PressureState();
    private EnderLiquidStorage storage;
    private boolean described;

    static {
        int i = 0;
        while (i < 3) {
            TileEnderTank.buttonT[i] = new Scale(0.6).with((Transformation)new Translation(0.35 + (double)i * 0.15, 0.91, 0.5));
            TileEnderTank.selectionBoxes[i] = selection_button.copy().apply(buttonT[i]);
            ++i;
        }
        TileEnderTank.selectionBoxes[3] = new Cuboid6(0.358, 0.268, 0.05, 0.662, 0.565, 0.15);
    }

    @Override
    public void h() {
        super.h();
        this.pressure_state.update(this.k.I);
        if (this.pressure_state.a_pressure) {
            this.ejectLiquid();
        }
        this.liquid_state.update(this.k.I);
    }

    private void ejectLiquid() {
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        int n = ForgeDirection.VALID_DIRECTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            ForgeDirection side = forgeDirectionArray[n2];
            asm t = this.k.r(this.l + side.offsetX, this.m + side.offsetY, this.n + side.offsetZ);
            if (t instanceof IFluidHandler) {
                int qty;
                IFluidHandler c = (IFluidHandler)t;
                FluidStack liquid = this.drain(null, 100, false);
                if (liquid != null && (qty = c.fill(side.getOpposite(), liquid, true)) > 0) {
                    this.drain(null, qty, true);
                }
            }
            ++n2;
        }
    }

    @Override
    public void reloadStorage() {
        this.storage = (EnderLiquidStorage)EnderStorageManager.instance(this.k.I).getStorage(this.owner, this.freq, "liquid");
        if (!this.k.I) {
            this.liquid_state.reloadStorage(this.storage);
        }
    }

    @Override
    public EnderLiquidStorage getStorage() {
        return this.storage;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.storage.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.storage.drain(from, maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.storage.canDrain(from, fluid);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.storage.canFill(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.storage.getTankInfo(from);
    }

    @Override
    public void onPlaced(oe entity) {
        this.rotation = (int)Math.floor((double)(entity.A * 4.0f / 360.0f) + 2.5) & 3;
        this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
    }

    @Override
    public void b(bx tag) {
        super.b(tag);
        tag.a("rot", (byte)this.rotation);
        tag.a("ir", this.pressure_state.invert_redstone);
    }

    @Override
    public void a(bx tag) {
        super.a(tag);
        this.rotation = tag.c("rot");
        this.pressure_state.invert_redstone = tag.n("ir");
    }

    @Override
    public void writeToPacket(PacketCustom packet) {
        packet.writeByte(this.rotation);
        packet.writeFluidStack(this.liquid_state.s_liquid);
        packet.writeBoolean(this.pressure_state.a_pressure);
    }

    @Override
    public void handleDescriptionPacket(PacketCustom desc) {
        super.handleDescriptionPacket(desc);
        this.rotation = desc.readUByte();
        this.liquid_state.s_liquid = desc.readFluidStack();
        this.pressure_state.a_pressure = desc.readBoolean();
        if (!this.described) {
            this.liquid_state.c_liquid = this.liquid_state.s_liquid;
            this.pressure_state.b_rotate = this.pressure_state.a_rotate = this.pressure_state.approachRotate();
        }
        this.described = true;
    }

    @Override
    public boolean activate(ue player, int subHit) {
        if (subHit == 4) {
            this.pressure_state.invert();
            return true;
        }
        return FluidUtils.fillTankWithContainer((IFluidHandler)this, (ue)player) || FluidUtils.emptyTankIntoContainer((IFluidHandler)this, (ue)player, (FluidStack)this.storage.getFluid());
    }

    @Override
    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        Vector3 pos = new Vector3((double)this.l, (double)this.m, (double)this.n);
        cuboids.add(new IndexedCuboid6((Object)0, new Cuboid6(0.15, 0.0, 0.15, 0.85, 0.916, 0.85).add(pos)));
        int i = 0;
        while (i < 4) {
            cuboids.add(new IndexedCuboid6((Object)(i + 1), selectionBoxes[i].copy().apply(Rotation.quarterRotations[(this.rotation + 2) % 4].at(Vector3.center)).add(pos)));
            ++i;
        }
    }

    @Override
    public int getLightValue() {
        if (this.liquid_state.s_liquid.amount > 0) {
            return FluidUtils.getLuminosity((FluidStack)this.liquid_state.c_liquid, (double)((double)this.liquid_state.s_liquid.amount / 16.0));
        }
        return 0;
    }

    @Override
    public boolean redstoneInteraction() {
        return true;
    }

    public void sync(PacketCustom packet) {
        if (packet.getType() == 5) {
            this.liquid_state.sync(packet.readFluidStack());
        } else if (packet.getType() == 6) {
            this.pressure_state.a_pressure = packet.readBoolean();
        }
    }

    public int getFacing() {
        return 0;
    }

    public boolean setFacing(int side) {
        return false;
    }

    public boolean rotateBlock() {
        this.rotation = (this.rotation + 1) % 4;
        PacketCustom.sendToChunk((ex)this.m(), (abv)this.k, (int)(this.l >> 4), (int)(this.n >> 4));
        return true;
    }

    public boolean setFacing(ForgeDirection side) {
        return false;
    }

    @Override
    public int comparatorInput() {
        FluidTankInfo tank = this.storage.getTankInfo(null)[0];
        return tank.fluid.amount * 14 / tank.capacity + (tank.fluid.amount > 0 ? 1 : 0);
    }

    public class EnderTankState
    extends TankSynchroniser.TankState {
        @Override
        public void sendSyncPacket() {
            PacketCustom packet = new PacketCustom((Object)"ES", 5);
            packet.writeCoord(TileEnderTank.this.l, TileEnderTank.this.m, TileEnderTank.this.n);
            packet.writeFluidStack(this.s_liquid);
            packet.sendToChunk(TileEnderTank.this.k, TileEnderTank.this.l >> 4, TileEnderTank.this.n >> 4);
        }

        @Override
        public void onLiquidChanged() {
            TileEnderTank.this.k.A(TileEnderTank.this.l, TileEnderTank.this.m, TileEnderTank.this.n);
        }
    }

    public class PressureState {
        public boolean invert_redstone;
        public boolean a_pressure;
        public boolean b_pressure;
        public double a_rotate;
        public double b_rotate;

        public void update(boolean client) {
            if (client) {
                this.b_rotate = this.a_rotate;
                this.a_rotate = MathHelper.approachExp((double)this.a_rotate, (double)this.approachRotate(), (double)0.5, (double)20.0);
            } else {
                this.b_pressure = this.a_pressure;
                this.a_pressure = TileEnderTank.this.k.C(TileEnderTank.this.l, TileEnderTank.this.m, TileEnderTank.this.n) ^ this.invert_redstone;
                if (this.a_pressure != this.b_pressure) {
                    this.sendSyncPacket();
                }
            }
        }

        public double approachRotate() {
            return this.a_pressure ? -90 : 90;
        }

        private void sendSyncPacket() {
            PacketCustom packet = new PacketCustom((Object)"ES", 6);
            packet.writeCoord(TileEnderTank.this.l, TileEnderTank.this.m, TileEnderTank.this.n);
            packet.writeBoolean(this.a_pressure);
            packet.sendToChunk(TileEnderTank.this.k, TileEnderTank.this.l >> 4, TileEnderTank.this.n >> 4);
        }

        public void invert() {
            this.invert_redstone = !this.invert_redstone;
            TileEnderTank.this.k.d(TileEnderTank.this.l, TileEnderTank.this.n).e();
        }
    }
}

