/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.item;

import codechicken.core.asm.InterfaceDependancies;
import codechicken.enderstorage.EnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.TileFrequencyOwner;
import codechicken.enderstorage.storage.item.EnderDyeButton;
import codechicken.enderstorage.storage.item.EnderItemStorage;
import codechicken.enderstorage.storage.item.EnderKnobSlot;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.api.tileentity.IReconfigurableFacing;

@InterfaceDependancies
public class TileEnderChest
extends TileFrequencyOwner
implements mn,
IReconfigurableFacing {
    public double a_lidAngle;
    public double b_lidAngle;
    public int c_numOpen;
    public int rotation;
    private EnderItemStorage storage;
    public static EnderDyeButton[] buttons = new EnderDyeButton[3];

    static {
        int i = 0;
        while (i < 3) {
            TileEnderChest.buttons[i] = new EnderDyeButton(i);
            ++i;
        }
    }

    public TileEnderChest(abv world, int metaData) {
        this.k = world;
        this.freq = metaData;
        this.c_numOpen = -1;
    }

    public TileEnderChest() {
    }

    @Override
    public void h() {
        super.h();
        if (this.k.h(this.l, this.m, this.n) != 0) {
            this.rotation = this.k.h(this.l, this.m, this.n);
            this.k.b(this.l, this.m, this.n, 0, 3);
        }
        if (!(this.k.I || this.k.J() % 20L != 0L && this.c_numOpen == this.storage.getNumOpen())) {
            this.c_numOpen = this.storage.getNumOpen();
            this.k.d(this.l, this.m, this.n, EnderStorage.blockEnderChest.cF, 1, this.c_numOpen);
        }
        this.b_lidAngle = this.a_lidAngle;
        this.a_lidAngle = MathHelper.approachLinear((double)this.a_lidAngle, (double)(this.c_numOpen > 0 ? 1 : 0), (double)0.1);
        if (this.b_lidAngle >= 0.5 && this.a_lidAngle < 0.5) {
            this.k.a((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5, "random.chestclosed", 0.5f, this.k.s.nextFloat() * 0.1f + 0.9f);
        } else if (this.b_lidAngle == 0.0 && this.a_lidAngle > 0.0) {
            this.k.a((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5, "random.chestopen", 0.5f, this.k.s.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean b(int i, int j) {
        if (i == 1) {
            this.c_numOpen = j;
            return true;
        }
        return false;
    }

    public double getRadianLidAngle(float frame) {
        double a = MathHelper.interpolate((double)this.b_lidAngle, (double)this.a_lidAngle, (double)frame);
        a = 1.0 - a;
        a = 1.0 - a * a * a;
        return a * 3.141593 * -0.5;
    }

    @Override
    public void reloadStorage() {
        this.storage = (EnderItemStorage)EnderStorageManager.instance(this.k.I).getStorage(this.owner, this.freq, "item");
    }

    @Override
    public EnderItemStorage getStorage() {
        return this.storage;
    }

    public int j_() {
        return this.storage.j_();
    }

    public yd a(int var1) {
        return this.storage.a(var1);
    }

    public yd a(int var1, int var2) {
        return this.storage.a(var1, var2);
    }

    public yd a_(int var1) {
        return this.storage.a_(var1);
    }

    public void a(int var1, yd var2) {
        this.storage.a(var1, var2);
    }

    public String b() {
        return "Ender Chest";
    }

    public int d() {
        return 64;
    }

    public boolean a(ue var1) {
        return true;
    }

    public void k_() {
    }

    public void g() {
    }

    @Override
    public void writeToPacket(PacketCustom packet) {
        packet.writeByte(this.rotation);
    }

    @Override
    public void handleDescriptionPacket(PacketCustom desc) {
        super.handleDescriptionPacket(desc);
        this.rotation = desc.readUByte();
    }

    @Override
    public void onPlaced(oe entity) {
        this.rotation = (int)Math.floor((double)(entity.A * 4.0f / 360.0f) + 2.5) & 3;
    }

    @Override
    public void b(bx tag) {
        super.b(tag);
        tag.a("rot", (byte)this.rotation);
    }

    @Override
    public void a(bx tag) {
        super.a(tag);
        this.rotation = tag.c("rot");
    }

    @Override
    public boolean activate(ue player, int subHit) {
        this.storage.openSMPGui(player, "tile.enderchest|0.name");
        return true;
    }

    @Override
    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        cuboids.add(new IndexedCuboid6((Object)0, new Cuboid6((double)this.l + 0.0625, (double)this.m, (double)this.n + 0.0625, (double)this.l + 0.9375, (double)this.m + 0.875, (double)this.n + 0.9375)));
        if (this.getRadianLidAngle(0.0f) < 0.0) {
            return;
        }
        int button = 0;
        while (button < 3) {
            EnderDyeButton ebutton = buttons[button].copy();
            ebutton.rotate(0.0, 0.5625, 0.0625, 1.0, 0.0, 0.0, 0.0);
            ebutton.rotateMeta(this.rotation);
            cuboids.add(new IndexedCuboid6((Object)(button + 1), new Cuboid6(ebutton.getMin(), ebutton.getMax()).add(Vector3.fromTileEntity((asm)this))));
            ++button;
        }
        cuboids.add(new IndexedCuboid6((Object)4, new Cuboid6(new EnderKnobSlot(this.rotation).getSelectionBB()).add(Vector3.fromTileEntity((asm)this))));
    }

    public int getFacing() {
        return 0;
    }

    public boolean setFacing(int side) {
        return false;
    }

    public boolean setFacing(ForgeDirection side) {
        return false;
    }

    public boolean rotateBlock() {
        this.rotation = (this.rotation + 1) % 4;
        PacketCustom.sendToChunk((ex)this.m(), (abv)this.k, (int)(this.l >> 4), (int)(this.n >> 4));
        return true;
    }

    public boolean b(int i, yd itemstack) {
        return true;
    }

    public boolean c() {
        return true;
    }

    @Override
    public int comparatorInput() {
        return ux.b((mn)this);
    }
}

