/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.item;

import codechicken.core.ClientUtils;
import codechicken.core.IGuiPacketSender;
import codechicken.core.ServerUtils;
import codechicken.core.inventory.InventoryUtils;
import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.internal.EnderStorageSPH;
import codechicken.enderstorage.storage.EnderItemStoragePlugin;
import codechicken.enderstorage.storage.item.ContainerEnderItemStorage;
import codechicken.enderstorage.storage.item.GuiEnderItemStorage;
import codechicken.lib.packet.PacketCustom;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class EnderItemStorage
extends AbstractEnderStorage
implements mn {
    private yd[] items;
    private int open;
    private int size = EnderItemStoragePlugin.configSize;

    public EnderItemStorage(EnderStorageManager manager, String owner, int freq) {
        super(manager, owner, freq);
        this.empty();
    }

    @Override
    public void loadFromTag(bx tag) {
        this.size = tag.c("size");
        this.empty();
        InventoryUtils.readItemStacksFromTag((yd[])this.items, (cf)tag.m("Items"));
        if (this.size != EnderItemStoragePlugin.configSize) {
            this.alignSize();
        }
    }

    private void alignSize() {
        if (EnderItemStoragePlugin.configSize > this.size) {
            yd[] newItems = new yd[EnderItemStoragePlugin.sizes[EnderItemStoragePlugin.configSize]];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
            this.size = EnderItemStoragePlugin.configSize;
            this.e();
        } else {
            int numStacks = 0;
            yd[] ydArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                yd item = ydArray[n2];
                if (item != null) {
                    ++numStacks;
                }
                ++n2;
            }
            if (numStacks <= EnderItemStoragePlugin.sizes[EnderItemStoragePlugin.configSize]) {
                yd[] newItems = new yd[EnderItemStoragePlugin.sizes[EnderItemStoragePlugin.configSize]];
                int copyTo = 0;
                yd[] ydArray2 = this.items;
                int n3 = this.items.length;
                int n4 = 0;
                while (n4 < n3) {
                    yd item = ydArray2[n4];
                    if (item != null) {
                        newItems[copyTo] = item;
                        ++copyTo;
                    }
                    ++n4;
                }
                this.items = newItems;
                this.size = EnderItemStoragePlugin.configSize;
                this.e();
            }
        }
    }

    @Override
    public String type() {
        return "item";
    }

    @Override
    public bx saveToTag() {
        if (this.size != EnderItemStoragePlugin.configSize && this.open == 0) {
            this.alignSize();
        }
        bx compound = new bx();
        compound.a("Items", (ck)InventoryUtils.writeItemStacksToTag((yd[])this.items));
        compound.a("size", (byte)this.size);
        return compound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public yd a(int slot) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return this.items[slot];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public yd a_(int slot) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return InventoryUtils.getStackInSlotOnClosing((mn)this, (int)slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(int slot, yd stack) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            this.items[slot] = stack;
            this.e();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void k_() {
        if (this.manager.client) {
            return;
        }
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            ++this.open;
            if (this.open == 1) {
                EnderStorageSPH.sendOpenUpdateTo(null, this.owner, this.freq, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void g() {
        if (this.manager.client) {
            return;
        }
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            --this.open;
            if (this.open == 0) {
                EnderStorageSPH.sendOpenUpdateTo(null, this.owner, this.freq, false);
            }
        }
    }

    public int getNumOpen() {
        return this.open;
    }

    public int j_() {
        return EnderItemStoragePlugin.sizes[this.size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public yd a(int slot, int size) {
        EnderItemStorage enderItemStorage = this;
        synchronized (enderItemStorage) {
            return InventoryUtils.decrStackSize((mn)this, (int)slot, (int)size);
        }
    }

    public String b() {
        return null;
    }

    public int d() {
        return 64;
    }

    public void e() {
        this.setDirty();
    }

    public boolean a(ue var1) {
        return true;
    }

    public void empty() {
        this.items = new yd[this.j_()];
    }

    public void openSMPGui(ue player, final String name) {
        ServerUtils.openSMPContainer((ju)((ju)player), (ux)new ContainerEnderItemStorage((mn)player.bn, this, false), (IGuiPacketSender)new IGuiPacketSender(){

            public void sendPacket(ju player, int windowId) {
                PacketCustom packet = new PacketCustom((Object)"ES", 2);
                packet.writeByte(windowId);
                packet.writeString(EnderItemStorage.this.owner);
                packet.writeShort(EnderItemStorage.this.freq);
                packet.writeString(name);
                packet.writeByte(EnderItemStorage.this.size);
                packet.sendToPlayer((ue)player);
            }
        });
    }

    public int getSize() {
        return this.size;
    }

    public int openCount() {
        return this.open;
    }

    public void setClientOpen(int i) {
        if (this.manager.client) {
            this.open = i;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void openClientGui(int windowID, uc playerInv, String name, int size) {
        this.size = size;
        this.empty();
        ClientUtils.openSMPGui((int)windowID, (awb)new GuiEnderItemStorage(playerInv, this, name));
    }

    public boolean b(int slot, yd stack) {
        return true;
    }

    public boolean c() {
        return true;
    }
}

