/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import java.util.Random;

public class WorldGenFirTreeHuge
extends afd {
    private static long lastSeed = 0L;

    private static void setBlockandMetadataIfChunkExists(abv world, int x, int y, int z2, int blockId, int metadata) {
        if (world.L().a(x >> 4, z2 >> 4)) {
            try {
                world.f(x, y, z2, blockId, metadata, 3);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public WorldGenFirTreeHuge(boolean doNotify) {
        super(doNotify);
    }

    public boolean a(abv world, Random rand, int x, int y, int z2) {
        lastSeed = rand.nextLong();
        return this.generateTree(world, new Random(lastSeed), x, y, z2);
    }

    public boolean generate(abv world, long seed, int x, int y, int z2) {
        lastSeed = seed;
        return this.generateTree(world, new Random(seed), x, y, z2);
    }

    private boolean generateTree(abv world, Random rand, int x, int y, int z2) {
        int height = rand.nextInt(16) + 32;
        int j = 1 + rand.nextInt(12);
        int k = height - j;
        int l = 2 + rand.nextInt(9);
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        for (int y1 = y; y1 <= y + 1 + height; ++y1) {
            if (y1 < 0 && y1 >= 256) {
                return false;
            }
            int k1 = 1;
            k1 = y1 - y < j ? 0 : l;
            for (int x1 = x - k1; x1 <= x + k1; ++x1) {
                for (int z1 = z2 - k1; z1 <= z2 + k1; ++z1) {
                    if (!world.L().a(x1 >> 4, z1 >> 4)) {
                        return false;
                    }
                    int id = world.a(x1, y1, z1);
                    if (aqw.s[id] == null || aqw.s[id].isLeaves(null, x1, y1, z1)) continue;
                    return false;
                }
            }
        }
        if (!TreeSoilRegistry.isValidSoil(world.a(x, y - 1, z2)) || y >= 256 - height - 1) {
            return false;
        }
        world.c(x, y - 1, z2, aqw.A.cF);
        world.c(x - 1, y - 1, z2, aqw.A.cF);
        world.c(x, y - 1, z2 - 1, aqw.A.cF);
        world.c(x - 1, y - 1, z2 - 1, aqw.A.cF);
        int l1 = rand.nextInt(2);
        int j2 = 1;
        boolean flag1 = false;
        for (int i3 = 0; i3 <= k; ++i3) {
            int k3 = y + height - i3;
            for (int i4 = x - l1; i4 <= x + l1; ++i4) {
                int k4 = i4 - x;
                for (int l4 = z2 - l1; l4 <= z2 + l1; ++l4) {
                    int i5 = l4 - z2;
                    if (Math.abs(k4) == l1 && Math.abs(i5) == l1 && l1 > 0) continue;
                    int blockID = world.a(i4, k3, l4);
                    if (blockID == 0 || aqw.s[blockID].canBeReplacedByLeaves(world, i4, k3, l4)) {
                        WorldGenFirTreeHuge.setBlockandMetadataIfChunkExists(world, i4, k3, l4, TreeBlock.LEAVES.getID(), TreeBlock.LEAVES.getMetadata());
                    }
                    if ((blockID = world.a(i4 - 1, k3, l4)) == 0 || aqw.s[blockID].canBeReplacedByLeaves(world, i4 - 1, k3, l4)) {
                        WorldGenFirTreeHuge.setBlockandMetadataIfChunkExists(world, i4 - 1, k3, l4, TreeBlock.LEAVES.getID(), TreeBlock.LEAVES.getMetadata());
                    }
                    if ((blockID = world.a(i4, k3, l4 - 1)) == 0 || aqw.s[blockID].canBeReplacedByLeaves(world, i4, k3, l4 - 1)) {
                        WorldGenFirTreeHuge.setBlockandMetadataIfChunkExists(world, i4, k3, l4 - 1, TreeBlock.LEAVES.getID(), TreeBlock.LEAVES.getMetadata());
                    }
                    if ((blockID = world.a(i4 - 1, k3, l4 - 1)) != 0 && !aqw.s[blockID].canBeReplacedByLeaves(world, i4 - 1, k3, l4 - 1)) continue;
                    WorldGenFirTreeHuge.setBlockandMetadataIfChunkExists(world, i4 - 1, k3, l4 - 1, TreeBlock.LEAVES.getID(), TreeBlock.LEAVES.getMetadata());
                }
            }
            if (l1 >= j2) {
                l1 = flag1 ? 1 : 0;
                flag1 = true;
                if (++j2 <= l) continue;
                j2 = l;
                continue;
            }
            ++l1;
        }
        int j3 = rand.nextInt(3);
        for (int l3 = 0; l3 < height - j3; ++l3) {
            int id = world.a(x, y + l3, z2);
            if (aqw.s[id] != null && !aqw.s[id].isLeaves(world, x, y + l3, z2)) continue;
            this.a(world, x, y + l3, z2, TreeBlock.TRUNK_SE.getID(), TreeBlock.TRUNK_SE.getMetadata());
            this.a(world, x - 1, y + l3, z2, TreeBlock.TRUNK_SW.getID(), TreeBlock.TRUNK_SW.getMetadata());
            this.a(world, x, y + l3, z2 - 1, TreeBlock.TRUNK_NE.getID(), TreeBlock.TRUNK_NE.getMetadata());
            this.a(world, x - 1, y + l3, z2 - 1, TreeBlock.TRUNK_NW.getID(), TreeBlock.TRUNK_NW.getMetadata());
        }
        return true;
    }

    public static long getLastSeed() {
        return lastSeed;
    }

    private static enum TreeBlock {
        LEAVES(new yd((aqw)aqw.P, 1, 1)),
        TRUNK_NE(new yd(aqw.O, 1, 1)),
        TRUNK_NW(new yd(aqw.O, 1, 1)),
        TRUNK_SE(new yd(aqw.O, 1, 1)),
        TRUNK_SW(new yd(aqw.O, 1, 1));

        private yd stack;
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_FIR.isPresent()) {
                TreeBlock.LEAVES.stack = Element.LEAVES_FIR.get();
            }
            if (Element.LOG_HUGE_FIR_NE.isPresent()) {
                TreeBlock.TRUNK_NE.stack = Element.LOG_HUGE_FIR_NE.get();
            }
            if (Element.LOG_HUGE_FIR_NW.isPresent()) {
                TreeBlock.TRUNK_NW.stack = Element.LOG_HUGE_FIR_NW.get();
            }
            if (Element.LOG_HUGE_FIR_SE.isPresent()) {
                TreeBlock.TRUNK_SE.stack = Element.LOG_HUGE_FIR_SE.get();
            }
            if (Element.LOG_HUGE_FIR_SW.isPresent()) {
                TreeBlock.TRUNK_SW.stack = Element.LOG_HUGE_FIR_SW.get();
            }
            loadedCustomBlocks = true;
        }

        private TreeBlock(yd stack) {
            this.stack = stack;
        }

        public int getID() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.d;
        }

        public int getMetadata() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.k();
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

