/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import extrabiomes.module.summa.worldgen.WorldGenNewTreeBase;
import java.util.LinkedList;
import java.util.Random;

public class WorldGenBaldCypressTree
extends WorldGenNewTreeBase {
    private static long lastSeed = 1234L;
    private static final int BASE_HEIGHT = 24;
    private static final int BASE_HEIGHT_VARIANCE = 10;
    private static final double TRUNK_HEIGHT_PERCENT = 0.75;
    private static final double TRUNK_BRANCHES_START = 0.25;
    private static final int BRANCHES_BASE_NUMBER = 15;
    private static final int BRANCHES_EXTRA = 10;
    private static final double TRUNCK_BRANCHES_PERCENT = 0.3;
    private static final int CANOPY_WIDTH = 15;
    private static final int CANOPY_WIDTH_VARIANCE = 5;
    private static final int CLUSTER_DIAMATER = 3;
    private static final int CLUSTER_DIAMATER_VARIANCE = 3;
    private static final int CLUSTER_HEIGHT = 1;
    private static final int CLUSTER_HEIGHT_VARIANCE = 3;
    static int last = 0;

    public WorldGenBaldCypressTree(boolean par1) {
        super(par1);
    }

    public boolean a(abv world, Random rand, int x, int y, int z2) {
        int blockId;
        lastSeed = rand.nextLong();
        int waterLevel = 0;
        for (int yy = y - 1; yy > y - 6 && ((blockId = world.a(x, yy, z2)) == aqw.G.cF || blockId == aqw.G.cF); --yy) {
            ++waterLevel;
        }
        if (!this.checkTree(world, new Random(lastSeed), x, y -= waterLevel, z2, waterLevel)) {
            return false;
        }
        return this.generateTree(world, new Random(lastSeed), x, y, z2, waterLevel);
    }

    public boolean generate(abv world, long seed, int x, int y, int z2) {
        int blockId;
        lastSeed = seed;
        int waterLevel = 0;
        for (int yy = y - 1; yy > y - 6 && ((blockId = world.a(x, yy, z2)) == aqw.G.cF || blockId == aqw.G.cF); --yy) {
            ++waterLevel;
        }
        if (!this.checkTree(world, new Random(lastSeed), x, y -= waterLevel, z2, waterLevel)) {
            return false;
        }
        return this.generateTree(world, new Random(seed), x, y, z2, waterLevel);
    }

    private boolean checkTree(abv world, Random rand, int x, int y, int z2, int waterLevel) {
        int below = world.a(x, y - 1, z2);
        int height = rand.nextInt(10) + 24;
        int width = 15 + rand.nextInt(5);
        int chunkCheck = width + 1;
        if (!(TreeSoilRegistry.isValidSoil(world.a(x, y - 1, z2)) && TreeSoilRegistry.isValidSoil(world.a(x + 1, y - 1, z2)) && TreeSoilRegistry.isValidSoil(world.a(x, y - 1, z2 + 1)) && TreeSoilRegistry.isValidSoil(world.a(x + 1, y - 1, z2 + 1)))) {
            return false;
        }
        if (y >= 256 - height - 4) {
            return false;
        }
        if (y < 1 || y + height + 4 > 256) {
            return false;
        }
        if (!world.e(x - chunkCheck, y - chunkCheck, z2 - chunkCheck, x + chunkCheck, y + chunkCheck, z2 + chunkCheck)) {
            return false;
        }
        if (!this.check2x2Trunk(x, y, z2, (int)((double)height * 0.75) + waterLevel, TreeBlock.TRUNK.get(), world, true)) {
            return false;
        }
        if (!this.checkBranches(world, rand, x, y, z2, height, width, waterLevel)) {
            return false;
        }
        return this.checkLeafCluster(world, x, (int)((double)height * 0.75) + y, z2, 4 + rand.nextInt(3), 4 + rand.nextInt(3));
    }

    private boolean generateTree(abv world, Random rand, int x, int y, int z2, int waterLevel) {
        int below = world.a(x, y - 1, z2);
        int height = rand.nextInt(10) + 24;
        int width = 15 + rand.nextInt(5);
        int chunkCheck = width + 1;
        if (!(TreeSoilRegistry.isValidSoil(world.a(x, y - 1, z2)) && TreeSoilRegistry.isValidSoil(world.a(x + 1, y - 1, z2)) && TreeSoilRegistry.isValidSoil(world.a(x, y - 1, z2 + 1)) && TreeSoilRegistry.isValidSoil(world.a(x + 1, y - 1, z2 + 1)))) {
            return false;
        }
        if (y >= 256 - height - 4) {
            return false;
        }
        if (y < 1 || y + height + 4 > 256) {
            return false;
        }
        if (!world.e(x - chunkCheck, y - chunkCheck, z2 - chunkCheck, x + chunkCheck, y + chunkCheck, z2 + chunkCheck)) {
            return false;
        }
        if (this.place2x2Trunk(x, y, z2, (int)((double)height * 0.75) + waterLevel, TreeBlock.TRUNK.get(), world)) {
            this.generateKnees(world, rand, x, y, z2, waterLevel);
            this.generateBranches(world, rand, x, y, z2, height, width, waterLevel);
            this.generateLeafCluster(world, x, (int)((double)height * 0.75) + y, z2, 4 + rand.nextInt(3), 4 + rand.nextInt(3), TreeBlock.LEAVES.get());
            return true;
        }
        return false;
    }

    public boolean checkBranches(abv world, Random rand, int x, int y, int z2, int height, int width, int startOffset) {
        int branchCount = 15 + rand.nextInt(10);
        width = width % 2 == 1 ? width + 1 : width;
        int offset = width / 2;
        int branchStart = (int)((double)height * 0.25) + startOffset;
        int maxBranchHeight = height - (int)((double)height * 0.25) - 3;
        int trunkStart = (int)((double)height * 0.75);
        int trunkRange = height - trunkStart;
        int[] start = new int[]{0, 0, 0};
        int[] end = new int[]{0, 0, 0};
        LinkedList<int[]> branches = new LinkedList<int[]>();
        for (int branch = 0; branch < branchCount; ++branch) {
            end[0] = rand.nextInt(width + 1) - offset + x;
            end[1] = rand.nextInt(maxBranchHeight) + branchStart + y;
            end[2] = rand.nextInt(width + 1) - offset + z2;
            start[1] = Math.max(branchStart + y, Math.min(height, rand.nextInt(Math.max(end[1] - branchStart - y, 1)) + y));
            if (end[0] > x && end[2] > z2) {
                start[0] = x + 1;
                start[2] = z2 + 1;
            } else if (end[0] > x) {
                start[0] = x + 1;
                start[2] = z2;
            } else if (end[2] > z2) {
                start[0] = x;
                start[2] = z2 + 1;
            } else {
                start[0] = x;
                start[2] = z2;
            }
            if (!this.checkBlockLine(start, end, TreeBlock.KNEE_LOG.get(), world)) {
                return false;
            }
            int[] node = new int[]{end[0], end[1], end[2]};
            branches.add(node);
        }
        for (int[] cluster : branches) {
            if (this.checkLeafCluster(world, cluster[0], cluster[1], cluster[2], 1 + rand.nextInt(3), 3 + rand.nextInt(3))) continue;
            return false;
        }
        return true;
    }

    public void generateBranches(abv world, Random rand, int x, int y, int z2, int height, int width, int startOffset) {
        int branchCount = 15 + rand.nextInt(10);
        width = width % 2 == 1 ? width + 1 : width;
        int offset = width / 2;
        int branchStart = (int)((double)height * 0.25) + startOffset;
        int maxBranchHeight = height - (int)((double)height * 0.25) - 3;
        int trunkStart = (int)((double)height * 0.75);
        int trunkRange = height - trunkStart;
        int[] start = new int[]{0, 0, 0};
        int[] end = new int[]{0, 0, 0};
        LinkedList<int[]> branches = new LinkedList<int[]>();
        for (int branch = 0; branch < branchCount; ++branch) {
            end[0] = rand.nextInt(width + 1) - offset + x;
            end[1] = rand.nextInt(maxBranchHeight) + branchStart + y;
            end[2] = rand.nextInt(width + 1) - offset + z2;
            start[1] = Math.max(branchStart + y, Math.min(height, rand.nextInt(Math.max(end[1] - branchStart - y, 1)) + y));
            if (end[0] > x && end[2] > z2) {
                start[0] = x + 1;
                start[2] = z2 + 1;
            } else if (end[0] > x) {
                start[0] = x + 1;
                start[2] = z2;
            } else if (end[2] > z2) {
                start[0] = x;
                start[2] = z2 + 1;
            } else {
                start[0] = x;
                start[2] = z2;
            }
            this.placeBlockLine(start, end, TreeBlock.KNEE_LOG.get(), world);
            int[] node = new int[]{end[0], end[1], end[2]};
            branches.add(node);
        }
        for (int[] cluster : branches) {
            this.generateLeafCluster(world, cluster[0], cluster[1], cluster[2], 1 + rand.nextInt(3), 3 + rand.nextInt(3), TreeBlock.LEAVES.get());
        }
    }

    public void generateKnees(abv world, Random rand, int x, int y, int z2, int bonusHeight) {
        switch (rand.nextInt(11)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.placeKnee(x - 1, y, z2, (rand.nextInt(3) != 0 ? 1 : 2) + bonusHeight, 2, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.placeKnee(x - 1, y, z2 + 1, (rand.nextInt(3) != 0 ? 1 : 2) + bonusHeight, 2, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                break;
            }
            case 8: {
                this.placeKnee(x - 1, y, z2, (rand.nextInt(5) != 0 ? 1 : 2) + bonusHeight, 2, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                this.placeKnee(x - 1, y, z2 + 1, (rand.nextInt(2) != 0 ? 1 : 2) + bonusHeight, 2, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                break;
            }
        }
        switch (rand.nextInt(11)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.placeKnee(x, y, z2 - 1, (rand.nextInt(3) != 0 ? 1 : 2) + bonusHeight, 3, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.placeKnee(x + 1, y, z2 - 1, (rand.nextInt(3) != 0 ? 1 : 2) + bonusHeight, 3, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                break;
            }
            case 8: {
                this.placeKnee(x, y, z2 - 1, (rand.nextInt(3) != 0 ? 1 : 2) + bonusHeight, 3, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                this.placeKnee(x + 1, y, z2 - 1, (rand.nextInt(5) != 0 ? 1 : 2) + bonusHeight, 3, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                break;
            }
        }
        switch (rand.nextInt(11)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.placeKnee(x + 2, y, z2, (rand.nextInt(3) != 0 ? 1 : 2) + bonusHeight, 0, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.placeKnee(x + 2, y, z2 + 1, (rand.nextInt(3) != 0 ? 1 : 2) + bonusHeight, 0, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                break;
            }
            case 8: {
                this.placeKnee(x + 2, y, z2, (rand.nextInt(3) != 0 ? 1 : 2) + bonusHeight, 0, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                this.placeKnee(x + 2, y, z2 + 1, (rand.nextInt(3) != 0 ? 1 : 2) + bonusHeight, 0, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                break;
            }
        }
        switch (rand.nextInt(11)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.placeKnee(x, y, z2 + 2, (rand.nextInt(3) != 0 ? 1 : 2) + bonusHeight, 1, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.placeKnee(x + 1, y, z2 + 2, (rand.nextInt(3) != 0 ? 1 : 2) + bonusHeight, 1, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                break;
            }
            case 8: {
                this.placeKnee(x, y, z2 + 2, (rand.nextInt(2) != 0 ? 1 : 2) + bonusHeight, 1, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                this.placeKnee(x + 1, y, z2 + 2, (rand.nextInt(5) != 0 ? 1 : 2) + bonusHeight, 1, TreeBlock.KNEE_LOG.get(), TreeBlock.KNEE.get(), world);
                break;
            }
        }
    }

    public static long getLastSeed() {
        return lastSeed;
    }

    private static enum TreeBlock {
        LEAVES(new yd((aqw)aqw.P, 1, 1)),
        TRUNK(new yd(aqw.O, 1, 1)),
        KNEE_LOG(new yd(aqw.O, 1, 1)),
        KNEE(new yd(aqw.O, 1, 1));

        private yd stack;
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_BALD_CYPRESS.isPresent()) {
                TreeBlock.LEAVES.stack = Element.LEAVES_BALD_CYPRESS.get();
            }
            if (Element.LOG_QUARTER_BALD_CYPRESS.isPresent()) {
                TreeBlock.TRUNK.stack = Element.LOG_QUARTER_BALD_CYPRESS.get();
            }
            if (Element.LOG_KNEE_BALD_CYPRESS.isPresent()) {
                TreeBlock.KNEE.stack = Element.LOG_KNEE_BALD_CYPRESS.get();
            }
            if (Element.LOG_BALD_CYPRESS.isPresent()) {
                TreeBlock.KNEE_LOG.stack = Element.LOG_BALD_CYPRESS.get();
            }
            loadedCustomBlocks = true;
        }

        private TreeBlock(yd stack) {
            this.stack = stack;
        }

        public yd get() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack;
        }

        public int getID() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.d;
        }

        public int getMetadata() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack.k();
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

