/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.amica.thermalexpansion;

import com.google.common.base.Optional;
import extrabiomes.Extrabiomes;
import extrabiomes.api.PluginEvent;
import extrabiomes.api.Stuff;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.Element;
import extrabiomes.module.amica.thermalexpansion.ThermalExpansionAPI;
import extrabiomes.module.fabrica.block.BlockCustomWood;
import net.minecraftforge.event.ForgeSubscribe;

public class ThermalExpansionPlugin {
    private static final String MODID = "ThermalExpansion";
    private static final String MOD_NAME = "Thermal Expansion";
    private Optional<ThermalExpansionAPI> api = Optional.absent();

    private void addSawmillRecipe(Element input, Optional<yd> output) {
        if (!output.isPresent() || !input.isPresent()) {
            return;
        }
        ((ThermalExpansionAPI)this.api.get()).addSawmillLogToPlankRecipe(input.get(), (yd)output.get());
    }

    private void addSawmillRecipes() {
        if (!this.api.isPresent()) {
            return;
        }
        this.addSawmillRecipe(Element.LOG_ACACIA, (Optional<yd>)Optional.of((Object)new yd((aqw)Stuff.planks.get(), 1, BlockCustomWood.BlockType.ACACIA.metadata())));
        for (Element input : new Element[]{Element.LOG_FIR, Element.LOG_HUGE_FIR_NE, Element.LOG_HUGE_FIR_NW, Element.LOG_HUGE_FIR_SE, Element.LOG_HUGE_FIR_SW}) {
            this.addSawmillRecipe(input, (Optional<yd>)Optional.of((Object)new yd((aqw)Stuff.planks.get(), 1, BlockCustomWood.BlockType.FIR.metadata())));
        }
        for (Element input : new Element[]{Element.LOG_HUGE_REDWOOD_NE, Element.LOG_HUGE_REDWOOD_NW, Element.LOG_HUGE_REDWOOD_SE, Element.LOG_HUGE_REDWOOD_SW}) {
            this.addSawmillRecipe(input, (Optional<yd>)Optional.of((Object)new yd((aqw)Stuff.planks.get(), 1, BlockCustomWood.BlockType.REDWOOD.metadata())));
        }
        for (Element input : new Element[]{Element.LOG_HUGE_OAK_NE, Element.LOG_HUGE_OAK_NW, Element.LOG_HUGE_OAK_SE, Element.LOG_HUGE_OAK_SW}) {
            this.addSawmillRecipe(input, (Optional<yd>)Optional.of((Object)new yd(aqw.C)));
        }
    }

    @ForgeSubscribe
    public void init(PluginEvent.Init event) {
        if (!this.api.isPresent()) {
            return;
        }
        this.addSawmillRecipes();
    }

    @ForgeSubscribe
    public void postInit(PluginEvent.Post event) {
        this.api = Optional.absent();
    }

    @ForgeSubscribe
    public void preInit(PluginEvent.Pre event) {
        if (!Extrabiomes.proxy.isModLoaded(MODID)) {
            return;
        }
        LogHelper.fine("Initializing %s plugin.", MOD_NAME);
        try {
            this.api = Optional.of((Object)new ThermalExpansionAPI());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogHelper.fine("Could not communicate with %s. Disabling plugin.", MOD_NAME);
            this.api = Optional.absent();
        }
    }
}

