/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.helpers;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Api;
import extrabiomes.api.DiscoverWorldTypesEvent;
import extrabiomes.lib.BiomeSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.Event;

public abstract class BiomeHelper {
    private static final Set<acf> worldTypes = new HashSet<acf>();
    private static Optional<? extends ArrayList<acp>> activeBiomes = Optional.absent();

    public static void addTerrainBlockstoBiome(BiomeSettings biome, int topBlockID, int fillerBlockID) {
        if (!biome.getBiome().isPresent()) {
            return;
        }
        acp baseBiome = (acp)biome.getBiome().get();
        baseBiome.A = (byte)topBlockID;
        baseBiome.B = (byte)fillerBlockID;
    }

    public static void createBiome(BiomeSettings setting) throws Exception {
        if (acp.a[setting.getID()] != null) {
            throw new IllegalArgumentException(String.format("Biome id %d is already in use by %s when adding %s. Please review the configuration file.", setting.getID(), acp.a[setting.getID()].y, setting.toString()));
        }
        setting.createBiome();
    }

    public static Set<acf> discoverWorldTypes() {
        if (worldTypes.isEmpty()) {
            worldTypes.add(acf.b);
            worldTypes.add(acf.d);
            DiscoverWorldTypesEvent event = new DiscoverWorldTypesEvent(worldTypes);
            Api.getExtrabiomesXLEventBus().post((Event)event);
        }
        return ImmutableSet.copyOf(worldTypes);
    }

    public static void enableBiome(Set<acf> worldTypes, acp biome) {
        Extrabiomes.proxy.addBiome(worldTypes, biome);
        BiomeManager.addSpawnBiome((acp)biome);
        BiomeManager.addStrongholdBiome((acp)biome);
    }

    public static Collection<acp> getActiveBiomes() {
        if (!activeBiomes.isPresent()) {
            activeBiomes = Optional.of(new ArrayList(BiomeSettings.values().length));
            for (BiomeSettings setting : BiomeSettings.values()) {
                if (!setting.getBiome().isPresent() || setting.isVanilla()) continue;
                ((ArrayList)activeBiomes.get()).add(setting.getBiome().get());
            }
            ((ArrayList)activeBiomes.get()).trimToSize();
        }
        return ImmutableSet.copyOf((Collection)((Collection)activeBiomes.get()));
    }

    public static acp settingToBiomeGenBase(BiomeSettings setting) {
        switch (setting) {
            case DESERT: {
                return acp.d;
            }
            case EXTREMEHILLS: {
                return acp.e;
            }
            case FOREST: {
                return acp.f;
            }
            case JUNGLE: {
                return acp.w;
            }
            case SWAMPLAND: {
                return acp.h;
            }
            case TAIGA: {
                return acp.g;
            }
            case PLAINS: {
                return acp.c;
            }
        }
        return (acp)setting.getBiome().get();
    }

    public static void addWeightedGrassGen(Optional<? extends acp> biome, afd grassGen, int weight) {
        if (!biome.isPresent()) {
            return;
        }
        extrabiomes.api.BiomeManager.addWeightedGrassGenForBiome((acp)biome.get(), grassGen, weight);
    }
}

