/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.handlers;

import com.google.common.base.Optional;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.lib.BlockSettings;
import extrabiomes.lib.DecorationSettings;
import extrabiomes.lib.GeneralSettings;
import extrabiomes.lib.ItemSettings;
import extrabiomes.lib.ModuleControlSettings;
import extrabiomes.lib.SaplingSettings;
import extrabiomes.utility.EnhancedConfiguration;
import java.io.File;
import java.util.logging.Level;
import net.minecraftforge.common.Property;

public abstract class ConfigurationHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(File configFile) {
        Optional optionalConfig = Optional.absent();
        try {
            optionalConfig = Optional.of((Object)((Object)new EnhancedConfiguration(configFile)));
            EnhancedConfiguration configuration = (EnhancedConfiguration)((Object)optionalConfig.get());
            for (BiomeSettings biomeSettings : BiomeSettings.values()) {
                biomeSettings.load(configuration);
            }
            for (Enum enum_ : DecorationSettings.values()) {
                ((DecorationSettings)enum_).load(configuration);
            }
            for (Enum enum_ : BlockSettings.values()) {
                ((BlockSettings)enum_).load(configuration);
            }
            for (Enum enum_ : ItemSettings.values()) {
                ((ItemSettings)enum_).load(configuration);
            }
            configuration.addCustomCategoryComment("saplingreplanting", "Settings to configure the chance that saplings will replant themselves up despawning on valid soil.");
            for (Enum enum_ : SaplingSettings.values()) {
                ((SaplingSettings)enum_).load(configuration);
            }
            for (Enum enum_ : ModuleControlSettings.values()) {
                ((ModuleControlSettings)enum_).load(configuration);
            }
            Property bigTreeSaplingDropRateProperty = configuration.get("general", "Relative sapling drops", false);
            bigTreeSaplingDropRateProperty.comment = "Setting relative sapling drops to true will decrease the amount of saplings dropped by decaying fir and redwood leaf blocks to a more reasonable amount.";
            GeneralSettings.bigTreeSaplingDropModifier = bigTreeSaplingDropRateProperty.getBoolean(false);
            Property consoleCommandsDisabled = configuration.get("general", "DisableConsoleCommands", true);
            consoleCommandsDisabled.comment = "Set to false to enable console commands.";
            GeneralSettings.consoleCommandsDisabled = consoleCommandsDisabled.getBoolean(true);
        }
        catch (Exception e) {
            LogHelper.log(Level.SEVERE, e, "%s had had a problem loading its configuration", "ExtrabiomesXL");
        }
        finally {
            if (optionalConfig.isPresent()) {
                ((EnhancedConfiguration)((Object)optionalConfig.get())).save();
            }
        }
    }
}

