/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.biomes;

import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import extrabiomes.api.BiomeManager;
import extrabiomes.helpers.BiomeHelper;
import extrabiomes.lib.BiomeSettings;
import extrabiomes.lib.Element;
import extrabiomes.module.summa.biome.WeightedRandomChooser;
import extrabiomes.module.summa.biome.WeightedWorldGenerator;
import extrabiomes.module.summa.worldgen.WorldGenAcacia;
import extrabiomes.module.summa.worldgen.WorldGenAutumnTree;
import extrabiomes.module.summa.worldgen.WorldGenBaldCypressTree;
import extrabiomes.module.summa.worldgen.WorldGenBigAutumnTree;
import extrabiomes.module.summa.worldgen.WorldGenCustomSwamp;
import extrabiomes.module.summa.worldgen.WorldGenCypressTree;
import extrabiomes.module.summa.worldgen.WorldGenFirTree;
import extrabiomes.module.summa.worldgen.WorldGenFirTreeHuge;
import extrabiomes.module.summa.worldgen.WorldGenJapaneseMapleShrub;
import extrabiomes.module.summa.worldgen.WorldGenJapaneseMapleTree;
import extrabiomes.module.summa.worldgen.WorldGenRainbowEucalyptusTree;
import extrabiomes.module.summa.worldgen.WorldGenRedwood;
import extrabiomes.module.summa.worldgen.WorldGenSakuraBlossomTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;

public class BiomeManagerImpl
extends BiomeManager {
    private static final afd CYPRESS_TREE_GEN = new WorldGenCypressTree(false);
    private static final afd ACACIA_TREE_GEN = new WorldGenAcacia(false);
    private static final afd ALT_TAIGA_GEN = new afw(false);
    private static final afd BIG_FIR_TREE_GEN = new WorldGenFirTreeHuge(false);
    private static final afd BIG_OAK_TREE_GEN = new aev(false);
    private static final afd BIRCH_TREE_GEN = new aew(false);
    private static final afd CUSTOM_SWAMP_TREE_GEN = new WorldGenCustomSwamp();
    private static final afd FERN_GEN = new afy(aqw.ac.cF, 2);
    private static final afd FIR_TREE_GEN = new WorldGenFirTree(false);
    private static final afd GRASS_GEN = new afy(aqw.ac.cF, 1);
    private static final afd OAK_TREE_GEN = new afz(false);
    private static final afd REDWOOD_TREE_GEN = new WorldGenRedwood(false);
    private static final afd SHRUB_GEN = new aff(3, 0);
    private static final afd SWAMP_TREE_GEN = new afx();
    private static final afd TAIGA_GEN = new afq();
    private static final afd JAPANESE_MAPLE_GEN = new WorldGenJapaneseMapleTree(false);
    private static final afd JAPANESE_MAPLE_SHRUB_GEN = new WorldGenJapaneseMapleShrub(false);
    private static final afd CYPRESS_GEN = new WorldGenCypressTree(false);
    private static final afd BALD_CYPRESS_GEN = new WorldGenBaldCypressTree(false);
    private static final afd RAINBOW_EUCALYPTUS_GEN = new WorldGenRainbowEucalyptusTree(false);
    private static final afd SAKURA_BLOSSOM_GEN = new WorldGenSakuraBlossomTree(false);
    private static final Collection<acp> disableDefaultGrassBiomes = new ArrayList<acp>();
    private static final Map<BiomeManager.GenType, Multimap<acp, WeightedWorldGenerator>> weightedChoices = new EnumMap<BiomeManager.GenType, Multimap<acp, WeightedWorldGenerator>>(BiomeManager.GenType.class);

    private static void addAlpineTrees(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), FIR_TREE_GEN, 100);
    }

    private static void addAutumnTrees(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), new afd(){

            public boolean a(abv world, Random rand, int x, int y, int z2) {
                WorldGenAutumnTree worldGen = new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.BROWN);
                WorldGenAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), new afd(){

            public boolean a(abv world, Random rand, int x, int y, int z2) {
                WorldGenBigAutumnTree worldGen = new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.BROWN);
                WorldGenBigAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), new afd(){

            public boolean a(abv world, Random rand, int x, int y, int z2) {
                WorldGenAutumnTree worldGen = new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.ORANGE);
                WorldGenAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), new afd(){

            public boolean a(abv world, Random rand, int x, int y, int z2) {
                WorldGenBigAutumnTree worldGen = new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.ORANGE);
                WorldGenBigAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), new afd(){

            public boolean a(abv world, Random rand, int x, int y, int z2) {
                WorldGenAutumnTree worldGen = new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.PURPLE);
                WorldGenAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), new afd(){

            public boolean a(abv world, Random rand, int x, int y, int z2) {
                WorldGenBigAutumnTree worldGen = new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.PURPLE);
                WorldGenBigAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), new afd(){

            public boolean a(abv world, Random rand, int x, int y, int z2) {
                WorldGenAutumnTree worldGen = new WorldGenAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.YELLOW);
                WorldGenAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), new afd(){

            public boolean a(abv world, Random rand, int x, int y, int z2) {
                WorldGenBigAutumnTree worldGen = new WorldGenBigAutumnTree(false, WorldGenAutumnTree.AutumnTreeType.YELLOW);
                WorldGenBigAutumnTree.setTrunkBlock(Element.LOG_AUTUMN.get().d, Element.LOG_AUTUMN.get().k());
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), OAK_TREE_GEN, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), BIG_OAK_TREE_GEN, 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), JAPANESE_MAPLE_GEN, 30);
    }

    private static void addBirchForestTrees(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), OAK_TREE_GEN, 99);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), BIG_OAK_TREE_GEN, 1);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), BIRCH_TREE_GEN, 9650);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), SAKURA_BLOSSOM_GEN, 250);
    }

    private static void addDefaultTrees(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), OAK_TREE_GEN, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), BIG_OAK_TREE_GEN, 10);
    }

    private static void addExtremeJungleTrees(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), BIG_OAK_TREE_GEN, 4);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), SHRUB_GEN, 18);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), RAINBOW_EUCALYPTUS_GEN, 20);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), new afd(){

            public boolean a(abv world, Random rand, int x, int y, int z2) {
                afn worldGen = new afn(false, 10 + rand.nextInt(20), 3, 3);
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 6);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), new afd(){

            public boolean a(abv world, Random rand, int x, int y, int z2) {
                afz worldGen = new afz(false, 4 + rand.nextInt(7), 3, 3, true);
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 12);
    }

    private static void addGrass(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        if (!disableDefaultGrassBiomes.contains(biome.get())) {
            BiomeManagerImpl.addWeightedGrassGenForBiome((acp)biome.get(), GRASS_GEN, 100);
        }
    }

    private static void addGrassandFerns(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedGrassGenForBiome((acp)biome.get(), FERN_GEN, 25);
        BiomeManagerImpl.addWeightedGrassGenForBiome((acp)biome.get(), GRASS_GEN, 75);
    }

    private static void addGreenSwampTrees(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), SWAMP_TREE_GEN, 15);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), CUSTOM_SWAMP_TREE_GEN, 75);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), BALD_CYPRESS_GEN, 150);
    }

    private static void addMiniJungleTrees(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), SWAMP_TREE_GEN, 100);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), OAK_TREE_GEN, 1);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), BIG_OAK_TREE_GEN, 99);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), RAINBOW_EUCALYPTUS_GEN, 20);
    }

    private static void addRainforestTrees(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), SWAMP_TREE_GEN, 9);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), BIG_OAK_TREE_GEN, 60);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), OAK_TREE_GEN, 19);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), RAINBOW_EUCALYPTUS_GEN, 32);
    }

    private static void addRedwoodForestTrees(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), REDWOOD_TREE_GEN, 100);
    }

    private static void addRedwoodLushTrees(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), REDWOOD_TREE_GEN, 50);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), FIR_TREE_GEN, 50);
    }

    private static void addSavannaTrees(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), ACACIA_TREE_GEN, 100);
    }

    private static void addShrublandTrees(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), new afd(){

            public boolean a(abv world, Random rand, int x, int y, int z2) {
                aff worldGen = new aff(3, rand.nextInt(3));
                return worldGen.a(world, rand, x, y, z2);
            }
        }, 50);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), JAPANESE_MAPLE_SHRUB_GEN, 50);
    }

    private static void addTaigaTrees(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), TAIGA_GEN, 50);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), ALT_TAIGA_GEN, 100);
    }

    private static void addTemporateRainforest(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), BIG_FIR_TREE_GEN, 200);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), FIR_TREE_GEN, 100);
    }

    private static void addWoodlands(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), OAK_TREE_GEN, 84);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), BIG_OAK_TREE_GEN, 4);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), CYPRESS_GEN, 6);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), JAPANESE_MAPLE_SHRUB_GEN, 4);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), JAPANESE_MAPLE_GEN, 6);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), SAKURA_BLOSSOM_GEN, 3);
    }

    private static void addGreenHills(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), OAK_TREE_GEN, 90);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), BIG_OAK_TREE_GEN, 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), SAKURA_BLOSSOM_GEN, 10);
    }

    private static void addForestedIsland(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), OAK_TREE_GEN, 85);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), BIG_OAK_TREE_GEN, 10);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), SAKURA_BLOSSOM_GEN, 5);
    }

    private static void addForestedHills(Optional<? extends acp> biome) {
        if (!biome.isPresent()) {
            return;
        }
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), OAK_TREE_GEN, 93);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), BIG_OAK_TREE_GEN, 8);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), CYPRESS_GEN, 5);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), JAPANESE_MAPLE_GEN, 6);
        BiomeManagerImpl.addWeightedTreeGenForBiome((acp)biome.get(), SAKURA_BLOSSOM_GEN, 4);
    }

    private static void buildWeightedBiomeGrassList() {
        BiomeManagerImpl.addGrass((Optional<? extends acp>)alpine);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)autumnwoods);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)birchforest);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends acp>)extremejungle);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)forestedhills);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)forestedisland);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)glacier);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)greenhills);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)greenswamp);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)icewasteland);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)marsh);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)meadow);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends acp>)minijungle);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)mountaindesert);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)mountainridge);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)mountaintaiga);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)pineforest);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends acp>)rainforest);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends acp>)redwoodforest);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends acp>)redwoodlush);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)savanna);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)shrubland);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)snowforest);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)snowyrainforest);
        BiomeManagerImpl.addGrassandFerns((Optional<? extends acp>)temperaterainforest);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)tundra);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)wasteland);
        BiomeManagerImpl.addGrass((Optional<? extends acp>)woodlands);
    }

    private static void buildWeightedBiomeTreeList() {
        BiomeManagerImpl.addAlpineTrees((Optional<? extends acp>)alpine);
        BiomeManagerImpl.addAutumnTrees((Optional<? extends acp>)autumnwoods);
        BiomeManagerImpl.addBirchForestTrees((Optional<? extends acp>)birchforest);
        BiomeManagerImpl.addExtremeJungleTrees((Optional<? extends acp>)extremejungle);
        BiomeManagerImpl.addForestedHills((Optional<? extends acp>)forestedhills);
        BiomeManagerImpl.addForestedIsland((Optional<? extends acp>)forestedisland);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acp>)glacier);
        BiomeManagerImpl.addGreenHills((Optional<? extends acp>)greenhills);
        BiomeManagerImpl.addGreenSwampTrees((Optional<? extends acp>)greenswamp);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acp>)icewasteland);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acp>)marsh);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acp>)meadow);
        BiomeManagerImpl.addMiniJungleTrees((Optional<? extends acp>)minijungle);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acp>)mountaindesert);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acp>)mountainridge);
        BiomeManagerImpl.addTaigaTrees((Optional<? extends acp>)mountaintaiga);
        BiomeManagerImpl.addTaigaTrees((Optional<? extends acp>)pineforest);
        BiomeManagerImpl.addRainforestTrees((Optional<? extends acp>)rainforest);
        BiomeManagerImpl.addRedwoodForestTrees((Optional<? extends acp>)redwoodforest);
        BiomeManagerImpl.addRedwoodLushTrees((Optional<? extends acp>)redwoodlush);
        BiomeManagerImpl.addSavannaTrees((Optional<? extends acp>)savanna);
        BiomeManagerImpl.addShrublandTrees((Optional<? extends acp>)shrubland);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acp>)snowforest);
        BiomeManagerImpl.addTemporateRainforest((Optional<? extends acp>)snowyrainforest);
        BiomeManagerImpl.addTemporateRainforest((Optional<? extends acp>)temperaterainforest);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acp>)tundra);
        BiomeManagerImpl.addDefaultTrees((Optional<? extends acp>)wasteland);
        BiomeManagerImpl.addWoodlands((Optional<? extends acp>)woodlands);
    }

    public static void disableDefaultGrassforBiomes(Collection<acp> biomes) {
        disableDefaultGrassBiomes.addAll(biomes);
    }

    public static void populateAPIBiomes() {
        alpine = BiomeSettings.ALPINE.getBiome();
        autumnwoods = BiomeSettings.AUTUMNWOODS.getBiome();
        birchforest = BiomeSettings.BIRCHFOREST.getBiome();
        extremejungle = BiomeSettings.EXTREMEJUNGLE.getBiome();
        forestedhills = BiomeSettings.FORESTEDHILLS.getBiome();
        forestedisland = BiomeSettings.FORESTEDISLAND.getBiome();
        glacier = BiomeSettings.GLACIER.getBiome();
        greenhills = BiomeSettings.GREENHILLS.getBiome();
        greenswamp = BiomeSettings.GREENSWAMP.getBiome();
        icewasteland = BiomeSettings.ICEWASTELAND.getBiome();
        marsh = BiomeSettings.MARSH.getBiome();
        meadow = BiomeSettings.MEADOW.getBiome();
        minijungle = BiomeSettings.MINIJUNGLE.getBiome();
        mountaindesert = BiomeSettings.MOUNTAINDESERT.getBiome();
        mountainridge = BiomeSettings.MOUNTAINRIDGE.getBiome();
        mountaintaiga = BiomeSettings.MOUNTAINTAIGA.getBiome();
        pineforest = BiomeSettings.PINEFOREST.getBiome();
        rainforest = BiomeSettings.RAINFOREST.getBiome();
        redwoodforest = BiomeSettings.REDWOODFOREST.getBiome();
        redwoodlush = BiomeSettings.REDWOODLUSH.getBiome();
        savanna = BiomeSettings.SAVANNA.getBiome();
        shrubland = BiomeSettings.SHRUBLAND.getBiome();
        snowforest = BiomeSettings.SNOWYFOREST.getBiome();
        snowyrainforest = BiomeSettings.SNOWYRAINFOREST.getBiome();
        temperaterainforest = BiomeSettings.TEMPORATERAINFOREST.getBiome();
        tundra = BiomeSettings.TUNDRA.getBiome();
        wasteland = BiomeSettings.WASTELAND.getBiome();
        woodlands = BiomeSettings.WOODLANDS.getBiome();
    }

    public BiomeManagerImpl() {
        ArrayListMultimap tree = ArrayListMultimap.create();
        weightedChoices.put(BiomeManager.GenType.TREE, (Multimap<acp, WeightedWorldGenerator>)tree);
        ArrayListMultimap grass = ArrayListMultimap.create();
        weightedChoices.put(BiomeManager.GenType.GRASS, (Multimap<acp, WeightedWorldGenerator>)grass);
        instance = Optional.of((Object)this);
    }

    @Override
    protected void addBiomeGen(BiomeManager.GenType genType, acp biome, afd treeGen, int weight) {
        Multimap<acp, WeightedWorldGenerator> choices = weightedChoices.get((Object)genType);
        choices.put((Object)biome, (Object)new WeightedWorldGenerator(treeGen, weight));
    }

    public static void buildWeightedFloraLists() {
        BiomeManagerImpl.buildWeightedBiomeTreeList();
        BiomeManagerImpl.buildWeightedBiomeGrassList();
    }

    @Override
    protected Optional<? extends afd> chooseBiomeRandomGen(BiomeManager.GenType genType, Random rand, acp biome) {
        Collection choicesForBiome;
        Optional randomItem;
        Optional choicesForGenType = Optional.fromNullable(weightedChoices.get((Object)genType));
        if (choicesForGenType.isPresent() && (randomItem = WeightedRandomChooser.getRandomItem(rand, choicesForBiome = ((Multimap)choicesForGenType.get()).get((Object)biome))).isPresent()) {
            return Optional.of((Object)((WeightedWorldGenerator)((Object)randomItem.get())).getWorldGen());
        }
        return Optional.absent();
    }

    @Override
    protected Collection<acp> getBiomeCollection() {
        return ImmutableSet.copyOf(BiomeHelper.getActiveBiomes());
    }

    @Override
    protected int getBiomeTotalWeight(BiomeManager.GenType genType, acp biome) {
        return WeightedRandomChooser.getTotalWeight(weightedChoices.get((Object)genType).get((Object)biome));
    }
}

