/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes;

import com.google.common.base.Optional;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import extrabiomes.Module;
import extrabiomes.PluginManager;
import extrabiomes.biomes.BiomeManagerImpl;
import extrabiomes.events.ModuleEvent;
import extrabiomes.events.ModulePreInitEvent;
import extrabiomes.handlers.BiomeHandler;
import extrabiomes.handlers.BlockHandler;
import extrabiomes.handlers.ConfigurationHandler;
import extrabiomes.handlers.EBXLCommandHandler;
import extrabiomes.handlers.ItemHandler;
import extrabiomes.handlers.RecipeHandler;
import extrabiomes.helpers.LogHelper;
import extrabiomes.lib.GeneralSettings;
import extrabiomes.localization.LocalizationHandler;
import extrabiomes.module.amica.treecapitator.TreeCapitatorPlugin;
import extrabiomes.module.fabrica.recipe.RecipeManager;
import extrabiomes.proxy.CommonProxy;
import extrabiomes.utility.CreativeTab;
import java.io.File;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.EventBus;

@Mod(modid="ExtrabiomesXL", name="ExtrabiomesXL", version="3.14.1")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class Extrabiomes {
    @Mod.Instance(value="ExtrabiomesXL")
    public static Extrabiomes instance;
    @SidedProxy(clientSide="extrabiomes.proxy.ClientProxy", serverSide="extrabiomes.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final wv tabsEBXL;
    private static final String LOG_MESSAGE_INITIALIZING = "log.message.initializing";
    private static final String LOG_MESSAGE_LOAD_SUCCESS = "log.message.load.success";
    public static final String TEXTURE_PATH;
    private static Optional<EventBus> initBus;

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) throws InstantiationException, IllegalAccessException {
        proxy.registerRenderInformation();
        Module.postEvent(new ModuleEvent.ModuleInitEvent());
        TreeCapitatorPlugin.init();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        PluginManager.activatePlugins();
        RecipeHandler.init();
        initBus = Optional.absent();
        Module.releaseStaticResources();
        LogHelper.info("Successfully Loaded.", new Object[0]);
    }

    public static boolean postInitEvent(Event event) {
        return initBus.isPresent() ? ((EventBus)initBus.get()).post(event) : false;
    }

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) throws Exception {
        LogHelper.info("Intializing.", new Object[0]);
        LocalizationHandler.loadLanguages();
        ConfigurationHandler.init(new File(event.getModConfigurationDirectory(), "/extrabiomes/extrabiomes.cfg"));
        BiomeHandler.init();
        BiomeManagerImpl.populateAPIBiomes();
        new BiomeManagerImpl();
        Extrabiomes.registerInitEventHandler(new RecipeManager());
        BlockHandler.createBlocks();
        ItemHandler.createItems();
        BiomeHandler.registerWorldGenerators();
        BiomeHandler.enableBiomes();
        BiomeManagerImpl.buildWeightedFloraLists();
        Module.registerModules();
        Module.postEvent(new ModulePreInitEvent());
        proxy.addStringLocalization("itemGroup.extrabiomesTab", "en_US", "ExtrabiomesXL");
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        if (GeneralSettings.consoleCommandsDisabled) {
            return;
        }
        MinecraftServer server = MinecraftServer.F();
        ac command = server.G();
        ik serverCommand = (ik)command;
        serverCommand.a((ab)new EBXLCommandHandler());
    }

    public static void registerInitEventHandler(Object target) {
        if (initBus.isPresent()) {
            ((EventBus)initBus.get()).register(target);
        }
    }

    static {
        tabsEBXL = new CreativeTab("extrabiomesTab");
        TEXTURE_PATH = "ExtrabiomesXL".toLowerCase() + ":";
        initBus = Optional.of((Object)new EventBus());
    }
}

