/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import mods.railcraft.common.blocks.ore.BlockOre;
import mods.railcraft.common.blocks.ore.EnumOre;
import mods.railcraft.common.plugins.forge.OreDictPlugin;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenGeode
extends WorldGenerator {
    private static final int DISTANCE_OUTER_SQ = 64;
    private static final int DISTANCE_ORE_SQ = 25;
    private static final int DISTANCE_INNER_SQ = 16;
    private final Block blockStone;
    private final int meta;
    public final Set ores = new HashSet();
    private final Block blockOre;

    public WorldGenGeode(Block block, int meta) {
        this.blockStone = block;
        this.meta = meta;
        this.ores.add(Block.field_71950_I.field_71990_ca);
        this.ores.add(Block.field_71949_H.field_71990_ca);
        this.ores.add(Block.field_71941_G.field_71990_ca);
        this.ores.add(Block.field_72073_aw.field_71990_ca);
        this.ores.add(Block.field_72068_bR.field_71990_ca);
        this.ores.add(Block.field_71947_N.field_71990_ca);
        this.ores.add(Block.field_94342_cr.field_71990_ca);
        this.ores.add(Block.field_72047_aN.field_71990_ca);
        this.ores.add(Block.field_72048_aO.field_71990_ca);
        this.ores.addAll(OreDictPlugin.getOreBlockIds());
        this.blockOre = BlockOre.getBlock();
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        for (int i = -8; i < 8; ++i) {
            for (int j = -8; j < 8; ++j) {
                for (int k = -8; k < 8; ++k) {
                    int distSq = i * i + j * j + k * k;
                    if (distSq <= 16) {
                        this.placeAir(world, rand, x + i, y + j, z + k);
                    } else if (distSq <= 64) {
                        this.placeStone(world, rand, x + i, y + j, z + k);
                    }
                    if (this.blockOre == null || distSq <= 16 || distSq > 25) continue;
                    this.placeOre(world, rand, x + i, y + j, z + k);
                }
            }
        }
        return true;
    }

    private void placeAir(World world, Random rand, int x, int y, int z) {
        if (this.isReplaceable(world, x, y, z)) {
            world.func_72832_d(x, y, z, 0, 0, 2);
        }
    }

    private void placeStone(World world, Random rand, int x, int y, int z) {
        if (this.isReplaceable(world, x, y, z)) {
            world.func_72832_d(x, y, z, this.blockStone.field_71990_ca, this.meta, 2);
        }
    }

    private void placeOre(World world, Random rand, int x, int y, int z) {
        if (world.func_72798_a(x, y, z) == this.blockStone.field_71990_ca) {
            double chance = rand.nextDouble();
            if (chance <= 0.002 && EnumOre.DARK_DIAMOND.isEnabled()) {
                world.func_72832_d(x, y, z, this.blockOre.field_71990_ca, EnumOre.DARK_DIAMOND.ordinal(), 2);
            } else if (chance <= 0.004 && EnumOre.DARK_EMERALD.isEnabled()) {
                world.func_72832_d(x, y, z, this.blockOre.field_71990_ca, EnumOre.DARK_EMERALD.ordinal(), 2);
            } else if (chance <= 0.01 && EnumOre.DARK_LAPIS.isEnabled()) {
                world.func_72832_d(x, y, z, this.blockOre.field_71990_ca, EnumOre.DARK_LAPIS.ordinal(), 2);
            }
        }
    }

    private boolean isReplaceable(World world, int x, int y, int z) {
        Block existing = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (existing == null) {
            return false;
        }
        if (existing.isGenMineableReplaceable(world, x, y, z, Block.field_71981_t.field_71990_ca)) {
            return true;
        }
        if (existing.isGenMineableReplaceable(world, x, y, z, Block.field_71979_v.field_71990_ca)) {
            return true;
        }
        if (existing.isGenMineableReplaceable(world, x, y, z, Block.field_71940_F.field_71990_ca)) {
            return true;
        }
        if (existing.isGenMineableReplaceable(world, x, y, z, Block.field_71939_E.field_71990_ca)) {
            return true;
        }
        return this.ores.contains(existing.field_71990_ca);
    }
}

