/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.ITileExtraDataHandler;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketTileExtraData
extends RailcraftPacket {
    private ITileExtraDataHandler tile;
    private ByteArrayOutputStream bytes;
    private DataOutputStream data;

    public PacketTileExtraData() {
    }

    public PacketTileExtraData(ITileExtraDataHandler tile) {
        this.tile = tile;
    }

    public DataOutputStream getDataStream() {
        if (this.data == null) {
            this.bytes = new ByteArrayOutputStream();
            this.data = new DataOutputStream(this.bytes);
        }
        return this.data;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.tile.getX());
        data.writeInt(this.tile.getY());
        data.writeInt(this.tile.getZ());
        data.write(this.bytes.toByteArray());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(DataInputStream data) throws IOException {
        int z;
        int y;
        int x;
        World world = Game.getWorld();
        TileEntity t = world.func_72796_p(x = data.readInt(), y = data.readInt(), z = data.readInt());
        if (t instanceof ITileExtraDataHandler) {
            ((ITileExtraDataHandler)t).onUpdatePacket(data);
        }
    }

    @Override
    public int getID() {
        return RailcraftPacket.PacketType.TILE_EXTRA_DATA.ordinal();
    }
}

