/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.AbstractPair;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SignalReceiver;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.RailcraftPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PacketPairUpdate
extends RailcraftPacket {
    private AbstractPair pairing;
    private RailcraftPacket.PacketType packetType;

    public PacketPairUpdate(RailcraftPacket.PacketType packetType) {
        this.packetType = packetType;
    }

    public PacketPairUpdate(AbstractPair pairing) {
        this.pairing = pairing;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.pairing.getTile().field_70329_l);
        data.writeInt(this.pairing.getTile().field_70330_m);
        data.writeInt(this.pairing.getTile().field_70327_n);
        Collection pairs = this.pairing.getPairs();
        data.writeByte(pairs.size());
        for (WorldCoordinate coord : pairs) {
            data.writeInt(coord.x);
            data.writeInt(coord.y);
            data.writeInt(coord.z);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(DataInputStream data) throws IOException {
        World world = Game.getWorld();
        int x = data.readInt();
        int y = data.readInt();
        int z = data.readInt();
        TileEntity tile = world.func_72796_p(x, y, z);
        if (this.packetType == RailcraftPacket.PacketType.CONTROLLER_UPDATE) {
            if (tile instanceof IControllerTile) {
                this.pairing = ((IControllerTile)tile).getController();
            }
        } else if (this.packetType == RailcraftPacket.PacketType.RECEIVER_UPDATE && tile instanceof IReceiverTile) {
            this.pairing = ((IReceiverTile)tile).getReceiver();
        }
        if (this.pairing != null) {
            try {
                this.pairing.clearPairings();
            }
            catch (Throwable error) {
                Game.logErrorAPI("Railcraft", error, AbstractPair.class);
            }
            int size = data.readByte();
            for (int i = 0; i < size; ++i) {
                this.pairing.addPair(data.readInt(), data.readInt(), data.readInt());
            }
        }
    }

    @Override
    public int getID() {
        if (this.pairing instanceof SignalController) {
            return RailcraftPacket.PacketType.CONTROLLER_UPDATE.ordinal();
        }
        if (this.pairing instanceof SignalReceiver) {
            return RailcraftPacket.PacketType.RECEIVER_UPDATE.ordinal();
        }
        return -1;
    }
}

