/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forestry;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import forestry.api.core.ItemInterface;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.plugins.forestry.IceManTickHandler;
import mods.railcraft.common.plugins.forestry.IcemanBackpack;
import mods.railcraft.common.plugins.forestry.TrackmanBackpack;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRedstoneLogic;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWall;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fluids.FluidStack;

public class ForestryPlugin {
    public static Boolean modLoaded = null;
    public static Item trackmanBackpackT1;
    public static Item trackmanBackpackT2;
    public static Item icemanBackpackT1;
    public static Item icemanBackpackT2;

    public static ItemStack getItem(String tag) {
        if (!ForestryPlugin.isForestryInstalled()) {
            return null;
        }
        try {
            return ItemInterface.getItem(tag);
        }
        catch (Throwable error) {
            Game.logErrorAPI("Forestry", error, ItemInterface.class);
            return null;
        }
    }

    public static void addBackpackItem(String pack, ItemStack stack) {
        if (stack == null) {
            return;
        }
        ForestryPlugin.sendBackpackMessage(String.format("%s@%d:%d", pack, stack.field_77993_c, stack.func_77960_j()));
    }

    public static void addBackpackItem(String pack, int id, int meta) {
        ForestryPlugin.sendBackpackMessage(String.format("%s@%d:%d", pack, id, meta));
    }

    public static void addBackpackItem(String pack, int id) {
        ForestryPlugin.sendBackpackMessage(String.format("%s@%d:*", pack, id));
    }

    private static void sendBackpackMessage(String message) {
        FMLInterModComms.sendMessage((String)"Forestry", (String)"add-backpack-items", (String)message);
    }

    public static void improveForestryBackpacks() {
        int id;
        for (id = 0; id < Block.field_71973_m.length; ++id) {
            if (Block.field_71973_m[id] == null) continue;
            if (Block.field_71973_m[id] instanceof IPlantable) {
                ForestryPlugin.addBackpackItem("forester", id);
            }
            if (Block.field_71973_m[id] instanceof IShearable) {
                ForestryPlugin.addBackpackItem("forester", id);
            }
            if (Block.field_71973_m[id] instanceof BlockLog) {
                ForestryPlugin.addBackpackItem("forester", id);
            }
            if (Block.field_71973_m[id] instanceof BlockMelon) {
                ForestryPlugin.addBackpackItem("forester", id);
            }
            if (Block.field_71973_m[id] instanceof BlockPumpkin) {
                ForestryPlugin.addBackpackItem("forester", id);
            }
            if (Block.field_71973_m[id] instanceof BlockStairs || Block.field_71973_m[id].func_71857_b() == 10) {
                ForestryPlugin.addBackpackItem("builder", id);
            }
            if (Block.field_71973_m[id] instanceof BlockFence || Block.field_71973_m[id].func_71857_b() == 11) {
                ForestryPlugin.addBackpackItem("builder", id);
            }
            if (Block.field_71973_m[id] instanceof BlockFenceGate || Block.field_71973_m[id].func_71857_b() == 21) {
                ForestryPlugin.addBackpackItem("builder", id);
            }
            if (Block.field_71973_m[id] instanceof BlockWall || Block.field_71973_m[id].func_71857_b() == 32) {
                ForestryPlugin.addBackpackItem("builder", id);
            }
            if (Block.field_71973_m[id] instanceof BlockBasePressurePlate) {
                ForestryPlugin.addBackpackItem("builder", id);
            }
            if (Block.field_71973_m[id] instanceof BlockLever) {
                ForestryPlugin.addBackpackItem("builder", id);
            }
            if (Block.field_71973_m[id] instanceof BlockTorch) {
                ForestryPlugin.addBackpackItem("builder", id);
            }
            if (Block.field_71973_m[id] instanceof BlockRedstoneLogic) {
                ForestryPlugin.addBackpackItem("builder", id);
            }
            if (Block.field_71973_m[id] instanceof BlockChest || Block.field_71973_m[id].func_71857_b() == 22) {
                ForestryPlugin.addBackpackItem("builder", id);
            }
            if (Block.field_71973_m[id] instanceof BlockWorkbench) {
                ForestryPlugin.addBackpackItem("builder", id);
            }
            if (Block.field_71973_m[id] instanceof BlockFurnace) {
                ForestryPlugin.addBackpackItem("builder", id);
            }
            if (Block.field_71973_m[id] instanceof BlockLadder || Block.field_71973_m[id].func_71857_b() == 8) {
                ForestryPlugin.addBackpackItem("builder", id);
            }
            if (!(Block.field_71973_m[id] instanceof BlockTrapDoor)) continue;
            ForestryPlugin.addBackpackItem("builder", id);
        }
        for (id = Item.field_77710_w.field_77779_bT; id < Item.field_77698_e.length; ++id) {
            if (Item.field_77698_e[id] == null) continue;
            if (Item.field_77698_e[id] instanceof IPlantable) {
                ForestryPlugin.addBackpackItem("forester", id);
                continue;
            }
            if (Item.field_77698_e[id] instanceof ItemFood) {
                ForestryPlugin.addBackpackItem("hunter", id);
                continue;
            }
            if (Item.field_77698_e[id] instanceof ItemDoor) {
                ForestryPlugin.addBackpackItem("builder", id);
                continue;
            }
            if (id == Item.field_77742_bb.field_77779_bT) {
                ForestryPlugin.addBackpackItem("builder", id);
                continue;
            }
            if (id != Item.field_94585_bY.field_77779_bT) continue;
            ForestryPlugin.addBackpackItem("builder", id);
        }
    }

    public static void registerBackpacks() {
        try {
            ItemStack output;
            ItemStack silk;
            ItemStack output2;
            if (BackpackManager.backpackInterface == null) {
                return;
            }
            String tag = "railcraft.backpack.trackman.t1";
            int id = RailcraftConfig.getItemId(tag);
            if (id > 0) {
                trackmanBackpackT1 = BackpackManager.backpackInterface.addBackpack(id, TrackmanBackpack.getInstance(), EnumBackpackType.T1).func_77637_a(CreativePlugin.TAB);
                RailcraftLanguage.instance().registerItemName(trackmanBackpackT1, tag);
                output2 = new ItemStack(trackmanBackpackT1);
                ForestryPlugin.addBackpackTooltip(output2);
                CraftingPlugin.addShapedRecipe(output2, "X#X", "VYV", "X#X", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('V'), new ItemStack(Block.field_72056_aG), Character.valueOf('X'), Item.field_77683_K, Character.valueOf('Y'), new ItemStack((Block)Block.field_72077_au));
            }
            if ((id = RailcraftConfig.getItemId(tag = "railcraft.backpack.trackman.t2")) > 0) {
                trackmanBackpackT2 = BackpackManager.backpackInterface.addBackpack(id, TrackmanBackpack.getInstance(), EnumBackpackType.T2).func_77637_a(CreativePlugin.TAB);
                RailcraftLanguage.instance().registerItemName(trackmanBackpackT2, tag);
                silk = ForestryPlugin.getItem("craftingMaterial");
                if (silk != null) {
                    silk.func_77964_b(3);
                    output = new ItemStack(trackmanBackpackT2);
                    ForestryPlugin.addBackpackTooltip(output);
                    RecipeManagers.carpenterManager.addRecipe(200, Fluids.WATER.get(1000), null, output, new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Item.field_77702_n, Character.valueOf('W'), silk, Character.valueOf('T'), trackmanBackpackT1});
                }
            }
            if ((id = RailcraftConfig.getItemId(tag = "railcraft.backpack.iceman.t1")) > 0) {
                icemanBackpackT1 = BackpackManager.backpackInterface.addBackpack(id, IcemanBackpack.getInstance(), EnumBackpackType.T1).func_77637_a(CreativePlugin.TAB);
                RailcraftLanguage.instance().registerItemName(icemanBackpackT1, tag);
                output2 = new ItemStack(icemanBackpackT1);
                ForestryPlugin.addBackpackTooltip(output2);
                CraftingPlugin.addShapedRecipe(output2, "X#X", "VYV", "X#X", Character.valueOf('#'), Block.field_72101_ab, Character.valueOf('V'), new ItemStack(Block.field_72039_aU), Character.valueOf('X'), Item.field_77683_K, Character.valueOf('Y'), new ItemStack((Block)Block.field_72077_au));
            }
            if ((id = RailcraftConfig.getItemId(tag = "railcraft.backpack.iceman.t2")) > 0) {
                icemanBackpackT2 = BackpackManager.backpackInterface.addBackpack(id, IcemanBackpack.getInstance(), EnumBackpackType.T2).func_77637_a(CreativePlugin.TAB);
                RailcraftLanguage.instance().registerItemName(icemanBackpackT2, tag);
                silk = ForestryPlugin.getItem("craftingMaterial");
                if (silk != null) {
                    silk.func_77964_b(3);
                    output = new ItemStack(icemanBackpackT2);
                    ForestryPlugin.addBackpackTooltip(output);
                    RecipeManagers.carpenterManager.addRecipe(200, Fluids.WATER.get(1000), null, output, new Object[]{"WXW", "WTW", "WWW", Character.valueOf('X'), Item.field_77702_n, Character.valueOf('W'), silk, Character.valueOf('T'), icemanBackpackT1});
                }
            }
            if (icemanBackpackT1 != null || icemanBackpackT2 != null) {
                TickRegistry.registerTickHandler((ITickHandler)new IceManTickHandler(), (Side)Side.SERVER);
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("Forestry", error, BackpackManager.class);
        }
    }

    private static void addBackpackTooltip(ItemStack stack) {
        NBTTagCompound nbt = InvTools.getItemData(stack);
        NBTTagCompound display = nbt.func_74775_l("display");
        nbt.func_74766_a("display", display);
        NBTTagList lore = display.func_74761_m("Lore");
        display.func_74782_a("Lore", (NBTBase)lore);
        lore.func_74742_a((NBTBase)new NBTTagString("madeby", "\u00a77\u00a7o" + RailcraftLanguage.translate("backpack.tooltip")));
    }

    public static void setupBackpackContents() {
        try {
            if (BackpackManager.backpackInterface == null) {
                return;
            }
            TrackmanBackpack.getInstance().setup();
            IcemanBackpack.getInstance().setup();
        }
        catch (Throwable error) {
            Game.logErrorAPI("Forestry", error, BackpackManager.class);
        }
    }

    public static boolean isForestryInstalled() {
        if (modLoaded == null) {
            modLoaded = Loader.isModLoaded((String)"Forestry");
        }
        return modLoaded;
    }

    public static void addCarpenterRecipe(String recipeTag, int packagingTime, FluidStack liquid, ItemStack box, ItemStack product, Object ... materials) {
        try {
            if (RecipeManagers.carpenterManager != null && RailcraftConfig.getRecipeConfig("forestry.carpenter." + recipeTag)) {
                RecipeManagers.carpenterManager.addRecipe(packagingTime, liquid, null, product, materials);
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("Forestry", error, RecipeManagers.class);
        }
    }
}

