/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.detector.EnumDetector;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.carts.EntityCartTank;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.items.ItemNugget;
import mods.railcraft.common.items.ItemPlate;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.modules.AbstractModule;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidContainerRegistry;

public class ModuleTransport
extends AbstractModule {
    private boolean tankCartEnabled = false;

    @Override
    public void initFirst() {
        EnumCart cart;
        EnumMachineGamma liquidUnloader;
        EnumMachineGamma liquidLoader;
        ItemStack detector;
        EnumMachineGamma itemUnloader;
        EnumMachineGamma itemLoader;
        EnumMachineAlpha alpha = EnumMachineAlpha.TANK_WATER;
        if (alpha.register()) {
            CraftingPlugin.addShapedOreRecipe(alpha.getItem(6), "WWW", "ISI", "WWW", Character.valueOf('I'), new ItemStack(Item.field_77703_o), Character.valueOf('S'), new ItemStack(Item.field_77761_aM), Character.valueOf('W'), "plankWood");
        }
        this.initIronTank();
        this.initSteelTank();
        EnumMachineBeta voidChest = EnumMachineBeta.VOID_CHEST;
        if (voidChest.register()) {
            CraftingPlugin.addShapedRecipe(voidChest.getItem(), "OOO", "OPO", "OOO", Character.valueOf('O'), new ItemStack(Block.field_72089_ap), Character.valueOf('P'), new ItemStack(Item.field_77730_bn));
        }
        if ((itemLoader = EnumMachineGamma.ITEM_LOADER).register()) {
            ItemStack stack = itemLoader.getItem();
            ItemStack detector2 = EnumDetector.ITEM.getItem();
            if (detector2 == null) {
                detector2 = new ItemStack(Block.field_72044_aK);
            }
            CraftingPlugin.addShapedRecipe(stack, "SSS", "SLS", "SDS", Character.valueOf('S'), new ItemStack(Block.field_71978_w), Character.valueOf('D'), detector2, Character.valueOf('L'), new ItemStack((Block)Block.field_94340_cs));
            itemLoader = EnumMachineGamma.ITEM_LOADER_ADVANCED;
            if (itemLoader.register()) {
                CraftingPlugin.addShapedOreRecipe(itemLoader.getItem(), "IRI", "RLR", "ISI", Character.valueOf('I'), "ingotSteel", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('S'), RailcraftToolItems.getSteelShovel(), Character.valueOf('L'), stack);
            }
        }
        if ((itemUnloader = EnumMachineGamma.ITEM_UNLOADER).register()) {
            ItemStack stack = itemUnloader.getItem();
            detector = EnumDetector.ITEM.getItem();
            if (detector == null) {
                detector = new ItemStack(Block.field_72044_aK);
            }
            CraftingPlugin.addShapedRecipe(stack, "SSS", "SDS", "SLS", Character.valueOf('S'), new ItemStack(Block.field_71978_w), Character.valueOf('D'), detector, Character.valueOf('L'), new ItemStack((Block)Block.field_94340_cs));
            itemUnloader = EnumMachineGamma.ITEM_UNLOADER_ADVANCED;
            if (itemUnloader.register()) {
                CraftingPlugin.addShapedOreRecipe(itemUnloader.getItem(), "IRI", "RLR", "ISI", Character.valueOf('I'), "ingotSteel", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('S'), RailcraftToolItems.getSteelShovel(), Character.valueOf('L'), stack);
            }
        }
        if ((liquidLoader = EnumMachineGamma.LIQUID_LOADER).register()) {
            detector = EnumDetector.TANK.getItem();
            if (detector == null) {
                detector = new ItemStack(Block.field_72044_aK);
            }
            CraftingPlugin.addShapedRecipe(liquidLoader.getItem(), "GLG", "G G", "GDG", Character.valueOf('D'), detector, Character.valueOf('G'), new ItemStack(Block.field_71946_M), Character.valueOf('L'), Block.field_94340_cs);
        }
        if ((liquidUnloader = EnumMachineGamma.LIQUID_UNLOADER).register()) {
            ItemStack detector3 = EnumDetector.TANK.getItem();
            if (detector3 == null) {
                detector3 = new ItemStack(Block.field_72044_aK);
            }
            CraftingPlugin.addShapedRecipe(liquidUnloader.getItem(), "GDG", "G G", "GLG", Character.valueOf('D'), detector3, Character.valueOf('G'), new ItemStack(Block.field_71946_M), Character.valueOf('L'), Block.field_94340_cs);
        }
        if ((cart = EnumCart.TANK).setup()) {
            this.tankCartEnabled = true;
            if (EnumMachineBeta.TANK_IRON_GAUGE.isAvaliable()) {
                CraftingPlugin.addShapedRecipe(cart.getCartItem(), "T", "M", Character.valueOf('T'), EnumMachineBeta.TANK_IRON_GAUGE.getItem(), Character.valueOf('M'), Item.field_77773_az);
            } else {
                CraftingPlugin.addShapedRecipe(cart.getCartItem(), "GGG", "GMG", "GGG", Character.valueOf('G'), new ItemStack(Block.field_71946_M), Character.valueOf('M'), Item.field_77773_az);
            }
            CraftingPlugin.addShapelessRecipe(new ItemStack(Item.field_77773_az), cart.getCartItem());
        }
    }

    @Override
    public void postInit() {
        if (this.tankCartEnabled) {
            ItemStack stackCartTank = EnumCart.TANK.getCartItem();
            for (FluidContainerRegistry.FluidContainerData container : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                ItemStack filteredCart = EntityCartTank.getCartItemForFilter(container.filledContainer);
                CraftingPlugin.addShapelessRecipe(filteredCart, stackCartTank, container.filledContainer);
                CraftingPlugin.addShapelessRecipe(stackCartTank, filteredCart);
            }
        }
    }

    private void addColorRecipes(EnumMachineBeta type) {
        for (EnumColor color : EnumColor.VALUES) {
            ItemStack output = this.getColorTank(type, color, 8);
            CraftingPlugin.addShapedOreRecipe(output, "OOO", "ODO", "OOO", Character.valueOf('O'), type.getItem(), Character.valueOf('D'), color.getDye());
        }
    }

    private ItemStack getColorTank(EnumMachineBeta type, EnumColor color, int qty) {
        ItemStack stack = type.getItem(qty);
        NBTTagCompound nbt = new NBTTagCompound("tag");
        stack.func_77982_d(nbt);
        nbt.func_74774_a("color", (byte)color.ordinal());
        return stack;
    }

    private boolean defineTank(EnumMachineBeta type, Object ... recipe) {
        if (type.register()) {
            this.addColorRecipes(type);
            CraftingPlugin.addShapedRecipe(this.getColorTank(type, EnumColor.WHITE, 8), recipe);
            return true;
        }
        return false;
    }

    private boolean defineIronTank(EnumMachineBeta type, Object ... recipe) {
        if (this.defineTank(type, recipe)) {
            RailcraftCraftingManager.blastFurnace.addRecipe(type.getItem(), true, false, 640, ItemNugget.getNugget(ItemNugget.EnumNugget.STEEL, 4));
            return true;
        }
        return false;
    }

    private void initIronTank() {
        this.defineIronTank(EnumMachineBeta.TANK_IRON_WALL, "PP", "PP", Character.valueOf('P'), ItemPlate.getPlate(ItemPlate.EnumPlate.IRON));
        this.defineIronTank(EnumMachineBeta.TANK_IRON_GAUGE, "GPG", "PGP", "GPG", Character.valueOf('P'), ItemPlate.getPlate(ItemPlate.EnumPlate.IRON), Character.valueOf('G'), new ItemStack(Block.field_72003_bq));
        this.defineIronTank(EnumMachineBeta.TANK_IRON_VALVE, "GPG", "PLP", "GPG", Character.valueOf('P'), ItemPlate.getPlate(ItemPlate.EnumPlate.IRON), Character.valueOf('L'), new ItemStack(Block.field_72043_aJ), Character.valueOf('G'), new ItemStack(Block.field_72002_bp));
    }

    private void initSteelTank() {
        this.defineTank(EnumMachineBeta.TANK_STEEL_WALL, "PP", "PP", Character.valueOf('P'), ItemPlate.getPlate(ItemPlate.EnumPlate.STEEL));
        this.defineTank(EnumMachineBeta.TANK_STEEL_GAUGE, "GPG", "PGP", "GPG", Character.valueOf('P'), ItemPlate.getPlate(ItemPlate.EnumPlate.STEEL), Character.valueOf('G'), new ItemStack(Block.field_72003_bq));
        this.defineTank(EnumMachineBeta.TANK_STEEL_VALVE, "GPG", "PLP", "GPG", Character.valueOf('P'), ItemPlate.getPlate(ItemPlate.EnumPlate.STEEL), Character.valueOf('L'), new ItemStack(Block.field_72043_aJ), Character.valueOf('G'), new ItemStack(Block.field_72002_bp));
    }
}

