/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.api.fuel.FuelManager;
import mods.railcraft.api.signals.SignalTools;
import mods.railcraft.client.sounds.SoundLimiterTicker;
import mods.railcraft.common.blocks.machine.MachineTileRegistery;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ItemCartVanilla;
import mods.railcraft.common.carts.LinkageHandler;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.carts.MinecartHooks;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.fluids.BucketHandler;
import mods.railcraft.common.fluids.FluidContainers;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.RailcraftFluids;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.items.CrowbarHandler;
import mods.railcraft.common.items.ItemCrowbar;
import mods.railcraft.common.items.ItemCrowbarReinforced;
import mods.railcraft.common.items.ItemGoggles;
import mods.railcraft.common.items.ItemMagnifyingGlass;
import mods.railcraft.common.items.ItemNugget;
import mods.railcraft.common.items.RailcraftPartItems;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.modules.AbstractModule;
import mods.railcraft.common.plugins.buildcraft.BuildcraftPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreeperPlugin;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.util.crafting.BlastFurnaceCraftingManager;
import mods.railcraft.common.util.crafting.CokeOvenCraftingManager;
import mods.railcraft.common.util.crafting.CraftingHandler;
import mods.railcraft.common.util.crafting.RockCrusherCraftingManager;
import mods.railcraft.common.util.crafting.RollingMachineCraftingManager;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.IMinecartCollisionHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModuleCore
extends AbstractModule {
    @Override
    public void preInit() {
        LinkageManager.reset();
        RailcraftCraftingManager.cokeOven = new CokeOvenCraftingManager();
        RailcraftCraftingManager.blastFurnace = new BlastFurnaceCraftingManager();
        RailcraftCraftingManager.rockCrusher = new RockCrusherCraftingManager();
        RailcraftCraftingManager.rollingMachine = new RollingMachineCraftingManager();
        SignalTools.packetBuilder = PacketBuilder.instance();
        RailcraftFluids.preInit();
        MinecraftForge.EVENT_BUS.register((Object)RailcraftFluids.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)BucketHandler.INSTANCE);
    }

    @Override
    public void initFirst() {
        ShapedOreRecipe recipe;
        NetworkRegistry.instance().registerGuiHandler((Object)Railcraft.getMod(), (IGuiHandler)new GuiHandler());
        LootPlugin.increaseLootGen(1, 2, "mineshaftCorridor", "villageBlacksmith");
        ItemCrowbar.registerItem();
        ItemCrowbarReinforced.registerItem();
        MinecraftForge.EVENT_BUS.register((Object)CrowbarHandler.instance());
        ItemMagnifyingGlass.register();
        RailcraftToolItems.initializeToolsArmor();
        ItemNugget.getNugget(ItemNugget.EnumNugget.IRON);
        EntityEnderman.field_70827_d[Block.field_71940_F.field_71990_ca] = false;
        BuildcraftPlugin.init();
        MinecraftForge.EVENT_BUS.register((Object)MinecartHooks.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)LinkageHandler.getInstance());
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new SoundLimiterTicker(), (Side)Side.CLIENT);
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new SoundLimiterTicker(), (Side)Side.SERVER);
        if (RailcraftConfig.useCollisionHandler()) {
            if (EntityMinecart.getCollisionHandler() != null) {
                Game.log(Level.CONFIG, "Existing Minecart Collision Handler detected, overwriting. Please check your configs to ensure this is desired behavior.", new Object[0]);
            }
            EntityMinecart.setCollisionHandler((IMinecartCollisionHandler)MinecartHooks.getInstance());
        }
        GameRegistry.registerCraftingHandler((ICraftingHandler)new CraftingHandler());
        HashSet<Integer> testSet = new HashSet<Integer>();
        if (!RailcraftConfig.useOldRecipes()) {
            testSet.add(Block.field_72056_aG.field_71990_ca);
            testSet.add(Block.field_71954_T.field_71990_ca);
            testSet.add(Block.field_71953_U.field_71990_ca);
            testSet.add(Block.field_94337_cv.field_71990_ca);
        }
        if (RailcraftConfig.getRecipeConfig("railcraft.cart.furnace")) {
            testSet.add(Item.field_77763_aO.field_77779_bT);
        }
        Iterator it = CraftingManager.func_77594_a().func_77592_b().iterator();
        while (it.hasNext()) {
            IRecipe r = (IRecipe)it.next();
            ItemStack output = r.func_77571_b();
            if (output == null || !testSet.contains(output.field_77993_c)) continue;
            it.remove();
        }
        this.replaceVanillaCart(EnumCart.BASIC, Item.field_77773_az);
        this.replaceVanillaCart(EnumCart.CHEST, Item.field_77762_aN);
        this.replaceVanillaCart(EnumCart.FURNACE, Item.field_77763_aO);
        this.replaceVanillaCart(EnumCart.TNT, Item.field_94582_cb);
        CraftingPlugin.addShapelessRecipe(new ItemStack(Item.field_77773_az), Item.field_77762_aN);
        CraftingPlugin.addShapelessRecipe(new ItemStack(Item.field_77773_az), Item.field_77763_aO);
        CraftingPlugin.addShapelessRecipe(new ItemStack(Item.field_77773_az), Item.field_94582_cb);
        LootPlugin.addLootMineshaft(EnumCart.BASIC.getCartItem(), 1, 1, "cart.basic");
        LootPlugin.addLootMineshaft(EnumCart.CHEST.getCartItem(), 1, 1, "cart.chest");
        LootPlugin.addLootMineshaft(EnumCart.TNT.getCartItem(), 1, 3, "cart.tnt");
        LootPlugin.addLootMineshaft(new ItemStack(Block.field_72056_aG), 8, 32, "track.basic");
        MinecraftForge.setBlockHarvestLevel((Block)Block.field_72056_aG, (String)"crowbar", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)Block.field_72056_aG, (String)"pickaxe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)Block.field_71954_T, (String)"crowbar", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)Block.field_71954_T, (String)"pickaxe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)Block.field_71953_U, (String)"crowbar", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)Block.field_71953_U, (String)"pickaxe", (int)0);
        if (RailcraftConfig.getRecipeConfig("railcraft.cart.bronze")) {
            recipe = new ShapedOreRecipe(new ItemStack(Item.field_77773_az), new Object[]{false, new Object[]{"I I", "III", Character.valueOf('I'), "ingotBronze"}});
            CraftingManager.func_77594_a().func_77592_b().add(recipe);
        }
        if (RailcraftConfig.getRecipeConfig("railcraft.cart.steel")) {
            recipe = new ShapedOreRecipe(new ItemStack(Item.field_77773_az, 2), new Object[]{false, new Object[]{"I I", "III", Character.valueOf('I'), "ingotSteel"}});
            CraftingManager.func_77594_a().func_77592_b().add(recipe);
        }
        if (!RailcraftConfig.useOldRecipes()) {
            ItemStack stackRailNormal = new ItemStack(Block.field_72056_aG, 32);
            ItemStack stackRailBooster = new ItemStack(Block.field_71954_T, 16);
            ItemStack stackRailDetector = new ItemStack(Block.field_71953_U, 16);
            ItemStack stackRailActivator = new ItemStack(Block.field_94337_cv, 16);
            CraftingPlugin.addShapedRecipe(stackRailNormal, "I I", "I#I", "I I", Character.valueOf('I'), RailcraftPartItems.getRailStandard(), Character.valueOf('#'), RailcraftPartItems.getRailbedWood());
            CraftingPlugin.addShapedRecipe(stackRailBooster, "I I", "I#I", "IrI", Character.valueOf('I'), RailcraftPartItems.getRailAdvanced(), Character.valueOf('#'), RailcraftPartItems.getRailbedWood(), Character.valueOf('r'), Item.field_77767_aC);
            CraftingPlugin.addShapedRecipe(stackRailDetector, "IsI", "I#I", "IrI", Character.valueOf('I'), RailcraftPartItems.getRailStandard(), Character.valueOf('#'), Block.field_72044_aK, Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('s'), RailcraftPartItems.getRailbedWood());
            CraftingPlugin.addShapedRecipe(stackRailActivator, "ItI", "I#I", "ItI", Character.valueOf('I'), RailcraftPartItems.getRailStandard(), Character.valueOf('#'), RailcraftPartItems.getRailbedWood(), Character.valueOf('t'), new ItemStack(Block.field_72035_aQ));
            CraftingPlugin.addShapelessRecipe(RailcraftPartItems.getRailStandard(), Block.field_72056_aG, Block.field_72056_aG, Block.field_72056_aG, Block.field_72056_aG, Block.field_72056_aG, Block.field_72056_aG, Block.field_72056_aG, Block.field_72056_aG);
            RailcraftLanguage.instance().registerItemName(stackRailNormal, "track.standard");
            RailcraftLanguage.instance().registerItemName(stackRailBooster, "track.powered");
            RailcraftLanguage.instance().registerItemName(stackRailDetector, "track.detector");
            RailcraftLanguage.instance().registerItemName(stackRailActivator, "track.activator");
        }
        MachineTileRegistery.registerTileEntities();
    }

    private void replaceVanillaCart(EnumCart cartType, Item original) {
        int itemIdOffset = Item.field_77695_f.field_77779_bT;
        int itemId = original.field_77779_bT;
        Item.field_77698_e[itemId] = null;
        ItemCartVanilla item = new ItemCartVanilla(itemId - itemIdOffset, cartType, original);
        cartType.registerEntity();
        GameRegistry.registerItem((Item)item, (String)cartType.getTag());
        ItemStack stack = new ItemStack((Item)item, 1);
        cartType.setCartItem(stack);
        RailcraftLanguage.instance().registerItemName(stack, cartType.getTag());
    }

    @Override
    public void initSecond() {
        if (RailcraftConfig.useCreosoteFurnaceRecipes() || !EnumMachineAlpha.COKE_OVEN.isAvaliable()) {
            FurnaceRecipes.func_77602_a().addSmelting(Item.field_77705_m.field_77779_bT, 0, FluidContainers.getCreosoteOilBottle(2), 0.0f);
            FurnaceRecipes.func_77602_a().addSmelting(Item.field_77705_m.field_77779_bT, 1, FluidContainers.getCreosoteOilBottle(1), 0.0f);
        }
        ItemGoggles.registerItem();
    }

    @Override
    public void postInit() {
        RailcraftFluids.postInit();
        GameRegistry.registerFuelHandler((IFuelHandler)FuelPlugin.getFuelHandler());
        ModuleCore.addLiquidFuels();
        FluidHelper.nerfWaterBottle();
        CreeperPlugin.postSetup();
    }

    public static void addLiquidFuels() {
        Fluid creosote;
        Fluid fuel;
        Fluid biofuel = Fluids.BIOFUEL.get();
        if (biofuel != null) {
            FuelManager.addBoilerFuel(biofuel, 32000);
            Game.log(Level.FINER, "Registered BioFuel as a valid Boiler fuel source.", new Object[0]);
        }
        if ((fuel = Fluids.FUEL.get()) != null) {
            FuelManager.addBoilerFuel(fuel, 96000);
            Game.log(Level.FINER, "Registered Fuel as a valid Boiler fuel source.", new Object[0]);
        }
        if ((creosote = Fluids.CREOSOTE.get()) != null) {
            FuelManager.addBoilerFuel(creosote, 4800);
            Game.log(Level.FINER, "Registered Creosote as a valid Boiler fuel source.", new Object[0]);
        }
    }
}

