/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.common.registry.GameRegistry;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.fluids.FluidContainers;
import mods.railcraft.common.items.ItemIngot;
import mods.railcraft.common.items.ItemRail;
import mods.railcraft.common.items.ItemRailbed;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.ItemTie;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.plugins.forge.LootPlugin;
import mods.railcraft.common.util.crafting.RollingMachineCraftingManager;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RailcraftPartItems {
    public static Item itemRail;
    public static Item itemTie;
    public static Item itemRailbed;
    private static Item itemRebar;
    private static Item itemTurbineBlade;
    private static Item itemTurbineDisk;
    private static Item itemTurbineRotor;
    public static Item itemSignalLamp;

    public static void registerItem(String tag, ItemStack stack) {
        ItemRegistry.registerItem(tag, stack);
    }

    private static Item getRailItem() {
        if (itemRail != null) {
            return itemRail;
        }
        String tag = "railcraft.part.rail";
        int id = RailcraftConfig.getItemId(tag);
        ItemRail item = new ItemRail(id);
        GameRegistry.registerItem((Item)item, (String)tag);
        itemRail = item;
        item.defineRecipes();
        for (int meta = 0; meta < 5; ++meta) {
            ItemStack stack = new ItemStack(itemRail, 1, meta);
            RailcraftLanguage.instance().registerItemName(stack, itemRail.func_77667_c(stack));
            RailcraftPartItems.registerItem(itemRail.func_77667_c(stack), stack);
        }
        return itemRail;
    }

    public static ItemStack getRailStandard() {
        return RailcraftPartItems.getRailStandard(1);
    }

    public static ItemStack getRailStandard(int qty) {
        return new ItemStack(RailcraftPartItems.getRailItem(), qty, 0);
    }

    public static ItemStack getRailAdvanced() {
        return RailcraftPartItems.getRailAdvanced(1);
    }

    public static ItemStack getRailAdvanced(int qty) {
        return new ItemStack(RailcraftPartItems.getRailItem(), qty, 1);
    }

    public static ItemStack getRailWood() {
        return RailcraftPartItems.getRailWood(1);
    }

    public static ItemStack getRailWood(int qty) {
        return new ItemStack(RailcraftPartItems.getRailItem(), qty, 2);
    }

    public static ItemStack getRailSpeed() {
        return RailcraftPartItems.getRailSpeed(1);
    }

    public static ItemStack getRailSpeed(int qty) {
        return new ItemStack(RailcraftPartItems.getRailItem(), qty, 3);
    }

    public static ItemStack getRailReinforced() {
        return RailcraftPartItems.getRailReinforced(1);
    }

    public static ItemStack getRailReinforced(int qty) {
        return new ItemStack(RailcraftPartItems.getRailItem(), qty, 4);
    }

    public static ItemStack getRebar() {
        return RailcraftPartItems.getRebar(1);
    }

    public static ItemStack getRebar(int qty) {
        Item item = itemRebar;
        if (item != null) {
            return new ItemStack(item, qty);
        }
        String tag = "railcraft.part.rebar";
        int id = RailcraftConfig.getItemId(tag);
        if (id <= 0) {
            return new ItemStack(Item.field_77703_o, qty);
        }
        item = new ItemRailcraft(id).func_77655_b(tag);
        GameRegistry.registerItem((Item)item, (String)tag);
        ItemStack stack = new ItemStack(item);
        RailcraftLanguage.instance().registerItemName(stack, tag);
        RailcraftPartItems.registerItem(tag, stack);
        RailcraftCraftingManager.rollingMachine.addRecipe(new ItemStack(item, 4), "  I", " I ", "I  ", Character.valueOf('I'), new ItemStack(Item.field_77703_o));
        ShapedOreRecipe recipe = new ShapedOreRecipe(new ItemStack(item, 4), new Object[]{true, new Object[]{"  I", " I ", "I  ", Character.valueOf('I'), "ingotBronze"}});
        RollingMachineCraftingManager.getInstance().getRecipeList().add(recipe);
        recipe = new ShapedOreRecipe(new ItemStack(item, 6), new Object[]{true, new Object[]{"  I", " I ", "I  ", Character.valueOf('I'), "ingotRefinedIron"}});
        RollingMachineCraftingManager.getInstance().getRecipeList().add(recipe);
        recipe = new ShapedOreRecipe(new ItemStack(item, 8), new Object[]{true, new Object[]{"  I", " I ", "I  ", Character.valueOf('I'), "ingotSteel"}});
        RollingMachineCraftingManager.getInstance().getRecipeList().add(recipe);
        itemRebar = item;
        return new ItemStack(item, qty);
    }

    private static Item getTieItem() {
        if (itemTie != null) {
            return itemTie;
        }
        String tag = "railcraft.part.tie";
        int id = RailcraftConfig.getItemId(tag);
        itemTie = new ItemTie(id);
        GameRegistry.registerItem((Item)itemTie, (String)tag);
        for (int meta = 0; meta < 2; ++meta) {
            ItemStack stack = new ItemStack(itemTie, 1, meta);
            RailcraftLanguage.instance().registerItemName(stack, itemTie.func_77667_c(stack));
            RailcraftPartItems.registerItem(itemTie.func_77667_c(stack), stack);
        }
        ItemStack tieWood = RailcraftPartItems.getTieWood();
        CraftingPlugin.addShapedOreRecipe(tieWood, " O ", "###", Character.valueOf('O'), FluidContainers.getCreosoteOilBucket(), Character.valueOf('#'), "slabWood");
        CraftingPlugin.addShapedOreRecipe(tieWood, " O ", "###", Character.valueOf('O'), FluidContainers.getCreosoteOilBottle(), Character.valueOf('#'), "slabWood");
        CraftingPlugin.addShapedOreRecipe(tieWood, " O ", "###", Character.valueOf('O'), FluidContainers.getCreosoteOilCan(), Character.valueOf('#'), "slabWood");
        CraftingPlugin.addShapedOreRecipe(tieWood, " O ", "###", Character.valueOf('O'), FluidContainers.getCreosoteOilWax(), Character.valueOf('#'), "slabWood");
        CraftingPlugin.addShapedOreRecipe(tieWood, " O ", "###", Character.valueOf('O'), FluidContainers.getCreosoteOilRefactory(), Character.valueOf('#'), "slabWood");
        CraftingPlugin.addShapedOreRecipe(tieWood, " O ", "###", Character.valueOf('O'), FluidContainers.getCreosoteOilCell(), Character.valueOf('#'), "slabWood");
        LootPlugin.addLootMineshaft(tieWood, 4, 16, "tie.wood");
        ItemStack tieStone = RailcraftPartItems.getTieStone();
        CraftingPlugin.addShapedRecipe(tieStone, " O ", "###", Character.valueOf('O'), RailcraftPartItems.getRebar(), Character.valueOf('#'), new ItemStack((Block)Block.field_72079_ak, 1, 0));
        return itemTie;
    }

    public static ItemStack getTieWood() {
        return RailcraftPartItems.getTieWood(1);
    }

    public static ItemStack getTieWood(int qty) {
        return new ItemStack(RailcraftPartItems.getTieItem(), qty, 0);
    }

    public static ItemStack getTieStone() {
        return RailcraftPartItems.getTieStone(1);
    }

    public static ItemStack getTieStone(int qty) {
        return new ItemStack(RailcraftPartItems.getTieItem(), qty, 1);
    }

    private static Item getRailbedItem() {
        if (itemRailbed != null) {
            return itemRailbed;
        }
        String tag = "railcraft.part.railbed";
        int id = RailcraftConfig.getItemId(tag);
        itemRailbed = new ItemRailbed(id);
        GameRegistry.registerItem((Item)itemRailbed, (String)tag);
        for (int meta = 0; meta < 2; ++meta) {
            ItemStack stack = new ItemStack(itemRailbed, 1, meta);
            RailcraftLanguage.instance().registerItemName(stack, itemRailbed.func_77667_c(stack));
            RailcraftPartItems.registerItem(itemRailbed.func_77667_c(stack), stack);
        }
        ItemStack output = new ItemStack(itemRailbed, 1, 0);
        CraftingManager.func_77594_a().func_77596_b(output, new Object[]{RailcraftPartItems.getTieWood(), RailcraftPartItems.getTieWood(), RailcraftPartItems.getTieWood(), RailcraftPartItems.getTieWood()});
        output = new ItemStack(itemRailbed, 1, 1);
        CraftingManager.func_77594_a().func_77596_b(output, new Object[]{RailcraftPartItems.getTieStone(), RailcraftPartItems.getTieStone(), RailcraftPartItems.getTieStone(), RailcraftPartItems.getTieStone()});
        return itemRailbed;
    }

    public static ItemStack getRailbedWood() {
        return RailcraftPartItems.getRailbedWood(1);
    }

    public static ItemStack getRailbedWood(int qty) {
        if (RailcraftConfig.useOldRecipes()) {
            return new ItemStack(Item.field_77669_D, qty);
        }
        return new ItemStack(RailcraftPartItems.getRailbedItem(), qty, 0);
    }

    public static ItemStack getRailbedStone() {
        return RailcraftPartItems.getRailbedStone(1);
    }

    public static ItemStack getRailbedStone(int qty) {
        if (RailcraftConfig.useOldRecipes()) {
            return new ItemStack((Block)Block.field_72079_ak, 1, 0);
        }
        return new ItemStack(RailcraftPartItems.getRailbedItem(), qty, 1);
    }

    public static ItemStack getTurbineBlade() {
        return RailcraftPartItems.getTurbineBlade(1);
    }

    public static ItemStack getTurbineBlade(int qty) {
        Item item = itemTurbineBlade;
        if (item != null) {
            return new ItemStack(item, qty);
        }
        if (!EnumMachineAlpha.TURBINE.isAvaliable()) {
            return null;
        }
        String tag = "railcraft.part.turbine.blade";
        int id = RailcraftConfig.getItemId(tag);
        if (id <= 0) {
            return ItemIngot.getIngot(ItemIngot.EnumIngot.STEEL, qty);
        }
        item = new ItemRailcraft(id).func_77655_b(tag);
        GameRegistry.registerItem((Item)item, (String)tag);
        ItemStack stack = new ItemStack(item);
        RailcraftLanguage.instance().registerItemName(stack, tag);
        RailcraftPartItems.registerItem(tag, stack);
        CraftingPlugin.addShapedOreRecipe(stack, "I", "I", "I", Character.valueOf('I'), "ingotSteel");
        itemTurbineBlade = item;
        return new ItemStack(item, qty);
    }

    public static ItemStack getTurbineDisk() {
        return RailcraftPartItems.getTurbineDisk(1);
    }

    public static ItemStack getTurbineDisk(int qty) {
        Item item = itemTurbineDisk;
        if (item != null) {
            return new ItemStack(item, qty);
        }
        if (!EnumMachineAlpha.TURBINE.isAvaliable()) {
            return null;
        }
        String tag = "railcraft.part.turbine.disk";
        int id = RailcraftConfig.getItemId(tag);
        if (id <= 0) {
            return null;
        }
        item = new ItemRailcraft(id).func_77655_b(tag);
        GameRegistry.registerItem((Item)item, (String)tag);
        ItemStack stack = new ItemStack(item);
        RailcraftLanguage.instance().registerItemName(stack, tag);
        RailcraftPartItems.registerItem(tag, stack);
        ItemStack blade = RailcraftPartItems.getTurbineBlade();
        if (blade != null) {
            CraftingPlugin.addShapedOreRecipe(stack, "BBB", "BAB", "BBB", Character.valueOf('A'), "blockSteel", Character.valueOf('B'), blade);
        }
        itemTurbineDisk = item;
        return new ItemStack(item, qty);
    }

    public static ItemStack getTurbineRotor() {
        return RailcraftPartItems.getTurbineRotor(1);
    }

    public static ItemStack getTurbineRotor(int qty) {
        Item item = itemTurbineRotor;
        if (item != null) {
            return new ItemStack(item, qty);
        }
        if (!EnumMachineAlpha.TURBINE.isAvaliable()) {
            return null;
        }
        String tag = "railcraft.part.turbine.rotor";
        int id = RailcraftConfig.getItemId(tag);
        if (id <= 0) {
            return null;
        }
        item = new ItemRailcraft(id).func_77655_b(tag);
        item.func_77656_e(30000).func_77625_d(1);
        GameRegistry.registerItem((Item)item, (String)tag);
        ItemStack stack = new ItemStack(item);
        RailcraftLanguage.instance().registerItemName(stack, tag);
        RailcraftPartItems.registerItem(tag, stack);
        ItemStack disk = RailcraftPartItems.getTurbineDisk();
        if (disk != null) {
            CraftingPlugin.addShapedRecipe(stack, "DDD", Character.valueOf('D'), disk);
        }
        itemTurbineRotor = item;
        return new ItemStack(item, qty);
    }

    public static ItemStack getSignalLamp() {
        return RailcraftPartItems.getSignalLamp(1);
    }

    public static ItemStack getSignalLamp(int qty) {
        Item item = itemSignalLamp;
        if (item != null) {
            return new ItemStack(item, qty);
        }
        String tag = "railcraft.part.signal.lamp";
        int id = RailcraftConfig.getItemId(tag);
        if (id <= 0) {
            return new ItemStack(Block.field_72078_bL, qty);
        }
        item = itemSignalLamp = new ItemRailcraft(id).func_77655_b(tag);
        GameRegistry.registerItem((Item)item, (String)tag);
        ItemStack stackSignalLamp = new ItemStack(item);
        RailcraftLanguage.instance().registerItemName(stackSignalLamp, tag);
        CraftingPlugin.addShapedOreRecipe(stackSignalLamp, "PG ", "PYT", "PRS", Character.valueOf('G'), EnumColor.LIME.getDye(), Character.valueOf('Y'), EnumColor.YELLOW.getDye(), Character.valueOf('R'), EnumColor.RED.getDye(), Character.valueOf('S'), Item.field_77767_aC, Character.valueOf('T'), Item.field_77751_aT, Character.valueOf('P'), Block.field_72003_bq);
        ItemRegistry.registerItem(tag, stackSignalLamp);
        return new ItemStack(item, qty);
    }
}

