/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.client.gui.GuiRoutingTable;
import mods.railcraft.common.blocks.signals.RoutingLogic;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IEditableItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemRoutingTable
extends ItemRailcraft
implements IEditableItem {
    public static final IStackFilter FILTER = new IStackFilter(){

        @Override
        public boolean matches(ItemStack stack) {
            if (stack == null || item == null) {
                return false;
            }
            return stack.field_77993_c == ItemRoutingTable.item.field_77779_bT;
        }
    };
    public static final int LINE_LENGTH = 37;
    public static final int LINES_PER_PAGE = 13;
    public static ItemRoutingTable item;

    public static void registerItem() {
        String tag;
        int id;
        if (item == null && (id = RailcraftConfig.getItemId(tag = "railcraft.routing.table")) > 0) {
            item = new ItemRoutingTable(id);
            item.func_77655_b(tag);
            RailcraftLanguage.instance().registerItemName(item, tag);
            CraftingPlugin.addShapelessOreRecipe(new ItemStack((Item)item), Item.field_77821_bF, "dyeBlue");
            ItemRegistry.registerItem(tag, new ItemStack((Item)item));
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack((Item)item);
    }

    @Override
    public boolean validateNBT(NBTTagCompound nbt) {
        return ItemRoutingTable.validBookTagContents(nbt);
    }

    public static boolean validBookTagContents(NBTTagCompound nbt) {
        if (!ItemRoutingTable.validBookTagPages(nbt)) {
            return false;
        }
        if (nbt.func_74764_b("title")) {
            String s = nbt.func_74779_i("title");
            return s != null && s.length() <= 16 ? nbt.func_74764_b("author") : false;
        }
        return true;
    }

    public static boolean validBookTagPages(NBTTagCompound nbt) {
        if (nbt == null) {
            return false;
        }
        if (!nbt.func_74764_b("pages")) {
            return false;
        }
        NBTTagList pages = (NBTTagList)nbt.func_74781_a("pages");
        for (int pageNum = 0; pageNum < pages.func_74745_c(); ++pageNum) {
            NBTTagList page = (NBTTagList)pages.func_74743_b(pageNum);
            if (page.func_74745_c() > 13) {
                return false;
            }
            for (int lineNum = 0; lineNum < page.func_74745_c(); ++lineNum) {
                NBTTagString line = (NBTTagString)page.func_74743_b(lineNum);
                if (line.field_74751_a == null) {
                    return false;
                }
                if (line.field_74751_a.length() <= 37) continue;
                return false;
            }
        }
        return true;
    }

    public static RoutingLogic getLogic(ItemStack routingTable) {
        LinkedList routingData = ItemRoutingTable.getContents(routingTable);
        return RoutingLogic.buildLogic(routingData);
    }

    public static LinkedList getContents(ItemStack routingTable) {
        if (routingTable == null || routingTable.field_77993_c != ItemRoutingTable.item.field_77779_bT) {
            return null;
        }
        NBTTagCompound nbt = routingTable.func_77978_p();
        if (nbt == null) {
            return null;
        }
        NBTTagList pages = (NBTTagList)nbt.func_74781_a("pages");
        LinkedList<String> contents = new LinkedList<String>();
        for (int pageNum = 0; pageNum < pages.func_74745_c(); ++pageNum) {
            NBTTagList page = (NBTTagList)pages.func_74743_b(pageNum);
            for (int lineNum = 0; lineNum < page.func_74745_c(); ++lineNum) {
                NBTTagString line = (NBTTagString)page.func_74743_b(lineNum);
                if (line.field_74751_a == null) continue;
                contents.add(line.field_74751_a);
            }
        }
        return contents;
    }

    public static List getPages(ItemStack routingTable) {
        if (routingTable == null || routingTable.field_77993_c != ItemRoutingTable.item.field_77779_bT) {
            return null;
        }
        NBTTagCompound nbt = routingTable.func_77978_p();
        if (nbt == null) {
            return null;
        }
        NBTTagList pages = (NBTTagList)nbt.func_74781_a("pages");
        LinkedList contents = new LinkedList();
        for (int pageNum = 0; pageNum < pages.func_74745_c(); ++pageNum) {
            NBTTagList pageNBT = (NBTTagList)pages.func_74743_b(pageNum);
            LinkedList<String> page = new LinkedList<String>();
            contents.add(page);
            for (int lineNum = 0; lineNum < pageNBT.func_74745_c(); ++lineNum) {
                NBTTagString line = (NBTTagString)pageNBT.func_74743_b(lineNum);
                if (line.field_74751_a == null) continue;
                page.add(line.field_74751_a);
            }
        }
        return contents;
    }

    public static String getOwner(ItemStack ticket) {
        if (ticket == null || !(ticket.func_77973_b() instanceof ItemTicket)) {
            return "";
        }
        NBTTagCompound nbt = ticket.func_77978_p();
        if (nbt == null) {
            return "";
        }
        return nbt.func_74779_i("author");
    }

    public ItemRoutingTable(int id) {
        super(id);
        this.func_77637_a(CreativePlugin.TAB);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("railcraft:routing.table");
    }

    public String func_77628_j(ItemStack stack) {
        NBTTagCompound nbt;
        NBTTagString title;
        if (stack.func_77942_o() && (title = (NBTTagString)(nbt = stack.func_77978_p()).func_74781_a("title")) != null) {
            return super.func_77628_j(stack) + " - " + title.toString();
        }
        return super.func_77628_j(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        NBTTagCompound nbt;
        NBTTagString author;
        if (stack.func_77942_o() && (author = (NBTTagString)(nbt = stack.func_77978_p()).func_74781_a("author")) != null) {
            list.add(EnumChatFormatting.GRAY + String.format(RailcraftLanguage.translate("routing.table.editor"), author.field_74751_a));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (Game.isNotHost(world)) {
            Minecraft.func_71410_x().func_71373_a((GuiScreen)new GuiRoutingTable(player, stack));
        }
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return false;
    }

    @Override
    public boolean canPlayerEdit(EntityPlayer player, ItemStack stack) {
        return true;
    }
}

