/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import java.util.Locale;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.ItemIngot;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.crafting.RollingMachineCraftingManager;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ItemPlate
extends ItemRailcraft {
    private static ItemPlate item;

    public static ItemStack getPlate(EnumPlate plate) {
        return ItemPlate.getPlate(plate, 1);
    }

    public static ItemStack getPlate(EnumPlate plate, int qty) {
        if (item != null) {
            return new ItemStack((Item)item, qty, plate.ordinal());
        }
        String tag = "railcraft.part.plate";
        int id = RailcraftConfig.getItemId(tag);
        if (id <= 0) {
            return null;
        }
        item = new ItemPlate(id);
        GameRegistry.registerItem((Item)item, (String)tag);
        for (EnumPlate p : EnumPlate.VALUES) {
            ItemStack stack = new ItemStack((Item)item, 1, p.ordinal());
            RailcraftLanguage.instance().registerItemName(stack, item.func_77667_c(stack));
            ItemRegistry.registerItem(item.func_77667_c(stack), stack);
        }
        return new ItemStack((Item)item, qty, plate.ordinal());
    }

    public ItemPlate(int i) {
        super(i);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("railcraft.part.plate");
        this.defineRecipes();
    }

    @Override
    public void func_94581_a(IconRegister iconRegister) {
        for (EnumPlate plate : EnumPlate.VALUES) {
            plate.icon = iconRegister.func_94245_a("railcraft:part.plate." + plate.name().toLowerCase(Locale.ENGLISH));
        }
    }

    public void func_77633_a(int id, CreativeTabs tab, List list) {
        for (int i = 0; i < 3; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
    }

    public Icon func_77617_a(int damage) {
        if (damage < 0 || damage >= EnumPlate.VALUES.length) {
            return EnumPlate.IRON.icon;
        }
        return EnumPlate.VALUES[damage].icon;
    }

    private void defineRecipes() {
        RailcraftCraftingManager.rollingMachine.addRecipe(new ItemStack((Item)this, 4), "II", "II", Character.valueOf('I'), Item.field_77703_o);
        ShapedOreRecipe recipe = new ShapedOreRecipe(new ItemStack((Item)this, 4, 1), new Object[]{"II", "II", Character.valueOf('I'), "ingotSteel"});
        RollingMachineCraftingManager.getInstance().getRecipeList().add(recipe);
        recipe = new ShapedOreRecipe(new ItemStack((Item)this, 4, 2), new Object[]{"IT", "TI", Character.valueOf('I'), Item.field_77703_o, Character.valueOf('T'), "ingotTin"});
        RollingMachineCraftingManager.getInstance().getRecipeList().add(recipe);
        RailcraftCraftingManager.blastFurnace.addRecipe(new ItemStack((Item)this, 1, EnumPlate.IRON.ordinal()), true, false, 1280, ItemIngot.getIngot(ItemIngot.EnumIngot.STEEL));
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77960_j();
        if (damage < 0 || damage >= EnumPlate.VALUES.length) {
            return "";
        }
        switch (EnumPlate.VALUES[damage]) {
            case IRON: {
                return "railcraft.part.plate.iron";
            }
            case STEEL: {
                return "railcraft.part.plate.steel";
            }
            case TIN: {
                return "railcraft.part.plate.tin";
            }
        }
        return "";
    }

    public static enum EnumPlate {
        IRON,
        STEEL,
        TIN;

        public static final EnumPlate[] VALUES;
        private Icon icon;

        static {
            VALUES = EnumPlate.values();
        }
    }
}

