/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.items;

import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.items.ItemRailcraft;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.CreeperPlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.EntityInteractEvent;

public class ItemMagnifyingGlass
extends ItemRailcraft
implements IActivationBlockingItem {
    private static Item item;

    public static void register() {
        if (item == null) {
            String tag = "tool.magnifying.glass";
            int id = RailcraftConfig.getItemId(tag);
            if (id > 0) {
                item = new ItemMagnifyingGlass(id);
                RailcraftLanguage.instance().registerItemName(item, tag);
                CraftingPlugin.addShapedRecipe(new ItemStack(item), " G", "S ", Character.valueOf('S'), new ItemStack(Item.field_77669_D), Character.valueOf('G'), new ItemStack(Block.field_72003_bq));
                ItemRegistry.registerItem(tag, new ItemStack(item));
            }
            CreeperPlugin.fixCreepers();
        }
    }

    public static ItemStack getItem() {
        if (item == null) {
            return null;
        }
        return new ItemStack(item);
    }

    public ItemMagnifyingGlass(int id) {
        super(id);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77655_b("railcraft.tool.mag.glass");
        this.func_77664_n();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.func_77637_a(CreativePlugin.TAB);
    }

    @ForgeSubscribe
    public void onEntityInteract(EntityInteractEvent event) {
        EntityPlayer thePlayer = event.entityPlayer;
        if (Game.isNotHost(thePlayer.field_70170_p)) {
            return;
        }
        Entity entity = event.target;
        thePlayer.func_71038_i();
        ItemStack stack = thePlayer.func_71045_bC();
        if (stack != null && stack.func_77973_b() instanceof ItemMagnifyingGlass && entity instanceof EntityMinecart) {
            EntityMinecart cart = (EntityMinecart)entity;
            String message = RailcraftLanguage.translate("gui.mag.glass.placedby");
            thePlayer.func_71035_c(String.format(message, Railcraft.getProxy().getItemDisplayName(cart.getCartItem()), CartTools.getCartOwner(cart)));
            event.setCanceled(true);
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (Game.isNotHost(world)) {
            return false;
        }
        TileEntity t = world.func_72796_p(x, y, z);
        if (t instanceof RailcraftTileEntity) {
            RailcraftTileEntity tile = (RailcraftTileEntity)t;
            String message = RailcraftLanguage.translate("gui.mag.glass.placedby");
            player.func_71035_c(String.format(message, tile.func_70303_b(), tile.getOwner()));
            return true;
        }
        return false;
    }
}

