/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteam;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.elements.FluidGauge;
import mods.railcraft.common.gui.elements.Indicator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerEngineSteam
extends RailcraftContainer {
    private TileEngineSteam tile;
    private float lastEnergy;
    private float lastOutput;

    public ContainerEngineSteam(InventoryPlayer inventoryplayer, TileEngineSteam tile) {
        this.tile = tile;
        this.addElement(new FluidGauge(tile.getTankManager().get(0), 71, 23, 176, 0, 16, 47));
        this.addElement(new Indicator(tile.getEnergyIndicator(), 94, 25, 176, 47, 6, 43));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)inventoryplayer, j, 8 + j * 18, 142));
        }
    }

    public void func_75132_a(ICrafting icrafting) {
        super.func_75132_a(icrafting);
        this.tile.getTankManager().initGuiData(this, icrafting, 0);
        icrafting.func_71112_a((Container)this, 12, Math.round(this.tile.energy));
        icrafting.func_71112_a((Container)this, 13, Math.round(this.tile.currentOutput * 100.0f));
    }

    public void func_75142_b() {
        super.func_75142_b();
        this.tile.getTankManager().updateGuiData(this, this.field_75149_d, 0);
        for (int var1 = 0; var1 < this.field_75149_d.size(); ++var1) {
            ICrafting var2 = (ICrafting)this.field_75149_d.get(var1);
            if (this.lastEnergy != this.tile.energy) {
                var2.func_71112_a((Container)this, 12, Math.round(this.tile.energy));
            }
            if (this.lastOutput == this.tile.currentOutput) continue;
            var2.func_71112_a((Container)this, 13, Math.round(this.tile.currentOutput * 100.0f));
        }
        this.lastEnergy = this.tile.energy;
        this.lastOutput = this.tile.currentOutput;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        this.tile.getTankManager().processGuiUpdate(id, value);
        switch (id) {
            case 12: {
                this.tile.energy = value;
                break;
            }
            case 13: {
                this.tile.currentOutput = (float)value / 100.0f;
            }
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.tile.func_70300_a(entityplayer);
    }
}

