/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids.tanks;

import java.util.Locale;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.gui.tooltips.ToolTipLine;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class StandardTank
extends FluidTank {
    private int tankIndex;
    protected final ToolTip toolTip = new ToolTip(){

        @Override
        public void refresh() {
            StandardTank.this.refreshTooltip();
        }
    };

    public StandardTank(int capacity) {
        super(capacity);
    }

    public StandardTank(int capacity, TileEntity tile) {
        this(capacity);
        this.tile = tile;
    }

    public void setTankIndex(int index) {
        this.tankIndex = index;
    }

    public int getTankIndex() {
        return this.tankIndex;
    }

    public boolean isEmpty() {
        return this.getFluid() == null || this.getFluid().amount <= 0;
    }

    public boolean isFull() {
        return this.getFluid() != null && this.getFluid().amount == this.getCapacity();
    }

    public Fluid getFluidType() {
        return this.getFluid() != null ? this.getFluid().getFluid() : null;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (resource.amount <= 0) {
            return 0;
        }
        return super.fill(resource, doFill);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        return super.drain(maxDrain, doDrain);
    }

    public ToolTip getToolTip() {
        return this.toolTip;
    }

    protected void refreshTooltip() {
        this.toolTip.clear();
        int amount = 0;
        if (this.getFluid() != null && this.getFluid().amount > 0) {
            ToolTipLine fluidName = new ToolTipLine(this.getFluid().getFluid().getLocalizedName());
            fluidName.setSpacing(2);
            this.toolTip.add(fluidName);
            amount = this.getFluid().amount;
        }
        this.toolTip.add(new ToolTipLine(String.format(Locale.ENGLISH, "%,d / %,d", amount, this.getCapacity())));
    }
}

