/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.fluids.tanks;

import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.gui.tooltips.ToolTipLine;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FilteredTank
extends StandardTank {
    private final Fluid filter;

    public FilteredTank(int capacity, Fluid filter) {
        this(capacity, filter, null);
    }

    public FilteredTank(int capacity, Fluid filter, TileEntity tile) {
        super(capacity, tile);
        this.filter = filter;
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        if (this.liquidMatchesFilter(resource)) {
            return super.fill(resource, doFill);
        }
        return 0;
    }

    public Fluid getFilter() {
        return this.filter;
    }

    public boolean liquidMatchesFilter(FluidStack resource) {
        if (resource == null || this.filter == null) {
            return false;
        }
        return resource.getFluid() == this.filter;
    }

    @Override
    protected void refreshTooltip() {
        this.toolTip.clear();
        int amount = 0;
        if (this.filter != null) {
            ToolTipLine name = new ToolTipLine(this.filter.getLocalizedName());
            name.setSpacing(2);
            this.toolTip.add(name);
            if (this.getFluid() != null) {
                amount = this.getFluid().amount;
            }
        }
        this.toolTip.add(new ToolTipLine(String.format("%,d", amount) + " / " + String.format("%,d", this.getCapacity())));
    }
}

