/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import mods.railcraft.common.carts.LinkageManager;
import net.minecraft.entity.item.EntityMinecart;

public class Train
implements Iterable {
    private final UUID uuid;
    private final Set carts = new HashSet();
    private final Set safeSet = Collections.unmodifiableSet(this.carts);
    private final Set lockingTracks = new HashSet();

    public Train(EntityMinecart cart) {
        this.uuid = UUID.randomUUID();
        this.addCartsToTrain(cart);
    }

    public Iterator iterator() {
        return new Iterator(){
            private Iterator it;
            private LinkageManager lm;
            {
                this.it = Train.this.carts.iterator();
                this.lm = LinkageManager.instance();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            public EntityMinecart next() {
                return this.lm.getCartFromLinkageId((UUID)this.it.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removing not supported.");
            }
        };
    }

    private void addCartsToTrain(EntityMinecart cart) {
        this.addCart(cart);
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart linkA = lm.getLinkedCartA(cart);
        EntityMinecart linkB = lm.getLinkedCartB(cart);
        if (linkA != null && !this.containsCart(linkA)) {
            this.addCartsToTrain(linkA);
        }
        if (linkB != null && !this.containsCart(linkB)) {
            this.addCartsToTrain(linkB);
        }
    }

    protected void releaseTrain() {
        LinkageManager lm = LinkageManager.instance();
        for (UUID id : this.carts) {
            EntityMinecart cart = lm.getCartFromLinkageId(id);
            if (cart == null) continue;
            cart.getEntityData().func_82580_o("rcTrainHigh");
            cart.getEntityData().func_82580_o("rcTrainLow");
        }
        this.carts.clear();
        this.lockingTracks.clear();
    }

    public UUID getUUID() {
        return this.uuid;
    }

    private void addCart(EntityMinecart cart) {
        this.carts.add(cart.getPersistentID());
        cart.getEntityData().func_74772_a("rcTrainHigh", this.uuid.getMostSignificantBits());
        cart.getEntityData().func_74772_a("rcTrainLow", this.uuid.getLeastSignificantBits());
    }

    public boolean containsCart(EntityMinecart cart) {
        if (cart == null) {
            return false;
        }
        return this.carts.contains(cart.getPersistentID());
    }

    public Set getCartsInTrain() {
        return this.safeSet;
    }

    public int getSize() {
        return this.carts.size();
    }

    public boolean isTrainLockedDown() {
        return !this.lockingTracks.isEmpty();
    }

    public void addLockingTrack(UUID track) {
        this.lockingTracks.add(track);
    }

    public void removeLockingTrack(UUID track) {
        this.lockingTracks.remove(track);
    }

    public static boolean isTrainLockedDown(EntityMinecart cart) {
        if (cart == null) {
            return false;
        }
        LinkageManager lm = LinkageManager.instance();
        Train train = lm.getTrain(cart);
        return train.isTrainLockedDown();
    }
}

