/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Constructor;
import java.util.Locale;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.carts.EntityCartAnchor;
import mods.railcraft.common.carts.EntityCartAnchorAdmin;
import mods.railcraft.common.carts.EntityCartAnchorPersonal;
import mods.railcraft.common.carts.EntityCartBasic;
import mods.railcraft.common.carts.EntityCartChest;
import mods.railcraft.common.carts.EntityCartEnergyBatBox;
import mods.railcraft.common.carts.EntityCartEnergyMFE;
import mods.railcraft.common.carts.EntityCartEnergyMFSU;
import mods.railcraft.common.carts.EntityCartFurnace;
import mods.railcraft.common.carts.EntityCartGift;
import mods.railcraft.common.carts.EntityCartPumpkin;
import mods.railcraft.common.carts.EntityCartTNT;
import mods.railcraft.common.carts.EntityCartTNTWood;
import mods.railcraft.common.carts.EntityCartTank;
import mods.railcraft.common.carts.EntityCartTrackRelayer;
import mods.railcraft.common.carts.EntityCartUndercutter;
import mods.railcraft.common.carts.EntityCartWork;
import mods.railcraft.common.carts.EntityLocomotiveSteam;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.carts.ItemCart;
import mods.railcraft.common.carts.ItemCartAnchor;
import mods.railcraft.common.carts.ItemLocomotive;
import mods.railcraft.common.carts.ItemTunnelBore;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public enum EnumCart {
    BASIC(1, 0, EntityCartBasic.class, null),
    CHEST(2, 0, EntityCartChest.class, new ItemStack((Block)Block.field_72077_au)),
    FURNACE(3, 0, EntityCartFurnace.class, new ItemStack(Block.field_72051_aB)),
    TNT_WOOD(4, 0, EntityCartTNTWood.class, new ItemStack(Block.field_72091_am)),
    TANK(5, 0, EntityCartTank.class, new ItemStack(Block.field_71946_M, 8)),
    ANCHOR(7, 0, EntityCartAnchor.class, null),
    WORK(8, 0, EntityCartWork.class, new ItemStack(Block.field_72060_ay)),
    TRACK_RELAYER(9, 1, EntityCartTrackRelayer.class, null),
    UNDERCUTTER(10, 1, EntityCartUndercutter.class, null),
    PUMPKIN(11, 3, EntityCartPumpkin.class, new ItemStack(Block.field_72061_ba)),
    GIFT(12, 3, EntityCartGift.class, null),
    ANCHOR_PERSONAL(13, 0, EntityCartAnchorPersonal.class, null),
    ANCHOR_ADMIN(14, 3, EntityCartAnchorAdmin.class, null),
    TNT(15, 0, EntityCartTNT.class, new ItemStack(Block.field_72091_am)),
    LOCO_STEAM(30, 1, EntityLocomotiveSteam.class, null),
    BORE(50, 1, EntityTunnelBore.class, null),
    ENERGY_BATBOX(87, 0, EntityCartEnergyBatBox.class, null),
    ENERGY_MFE(88, 0, EntityCartEnergyMFE.class, null),
    ENERGY_MFSU(89, 0, EntityCartEnergyMFSU.class, null);

    public static final EnumCart[] VALUES;
    private final Class type;
    private final byte id;
    private final byte rarity;
    private ItemStack contents = null;
    private ItemStack cartItem;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumCart(Class id, ItemStack rarity) {
        void contents;
        void type;
        this.id = (byte)id;
        this.rarity = (byte)rarity;
        this.type = type;
        this.contents = contents;
    }

    public byte getId() {
        return this.id;
    }

    public String getTag() {
        return "railcraft.cart." + this.name().toLowerCase(Locale.ENGLISH).replace('_', '.');
    }

    public Class getCartClass() {
        return this.type;
    }

    public void setContents(ItemStack stack) {
        this.contents = stack.func_77946_l();
    }

    public ItemStack getContents() {
        switch (this) {
            case TANK: {
                if (!EnumMachineBeta.TANK_IRON_GAUGE.isAvaliable()) break;
                return EnumMachineBeta.TANK_IRON_GAUGE.getItem();
            }
        }
        if (this.contents == null) {
            return null;
        }
        return this.contents.func_77946_l();
    }

    public EntityMinecart makeCart(ItemStack stack, World world, double i, double j, double k) {
        switch (this) {
            case TANK: {
                EntityCartTank cart = new EntityCartTank(world, i, j, k);
                ItemStack filter = EntityCartTank.getFilterFromCartItem(stack);
                cart.setFilter(filter);
                return cart;
            }
            case ANCHOR: {
                EntityCartAnchor cart = new EntityCartAnchor(world, i, j, k);
                long fuel = ItemCartAnchor.getFuel(stack);
                cart.setAnchorFuel(fuel);
                return cart;
            }
            case ANCHOR_PERSONAL: {
                EntityCartAnchorPersonal cart = new EntityCartAnchorPersonal(world, i, j, k);
                long fuel = ItemCartAnchor.getFuel(stack);
                cart.setAnchorFuel(fuel);
                return cart;
            }
            case LOCO_STEAM: {
                EntityLocomotiveSteam entity = new EntityLocomotiveSteam(world, i, j, k);
                entity.initEntityFromItem(stack);
                return entity;
            }
        }
        try {
            Constructor con = this.type.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE);
            EntityMinecart entity = (EntityMinecart)con.newInstance(world, i, j, k);
            return entity;
        }
        catch (Throwable ex) {
            Game.logError("Failed to create cart entity!", ex);
            return new EntityCartBasic(world, i, j, k);
        }
    }

    public ItemStack getCartItem() {
        if (this.cartItem == null) {
            return null;
        }
        return this.cartItem.func_77946_l();
    }

    public void setCartItem(ItemStack cartItem) {
        this.cartItem = cartItem.func_77946_l();
    }

    private ItemCart defineItem(int itemId) {
        switch (this) {
            case BORE: {
                return new ItemTunnelBore(itemId);
            }
            case LOCO_STEAM: {
                return new ItemLocomotive(itemId, this);
            }
            case ANCHOR: 
            case ANCHOR_PERSONAL: 
            case ANCHOR_ADMIN: {
                return new ItemCartAnchor(itemId, this);
            }
        }
        return new ItemCart(itemId, this);
    }

    public void registerEntity() {
        EntityRegistry.registerModEntity((Class)this.type, (String)this.getTag(), (int)this.id, (Object)Railcraft.getMod(), (int)80, (int)3, (boolean)true);
    }

    public boolean setup() {
        int itemId;
        String tag = this.getTag();
        boolean cartEnabled = RailcraftConfig.isCartEnabled(tag);
        if (cartEnabled && (itemId = RailcraftConfig.getItemId(tag)) > 0) {
            this.registerEntity();
            ItemCart item = this.defineItem(itemId);
            item.func_77655_b(tag);
            item.setRarity(this.rarity);
            GameRegistry.registerItem((Item)item, (String)tag);
            ItemStack stack = new ItemStack((Item)item);
            RailcraftLanguage.instance().registerItemName(stack, tag);
            this.setCartItem(stack);
            ItemRegistry.registerItem(tag, stack);
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        String tag = this.getTag();
        return RailcraftConfig.isCartEnabled(tag) && RailcraftConfig.getItemId(tag) > 0;
    }

    public static EnumCart fromClass(Class cls) {
        for (EnumCart cart : VALUES) {
            if (!cls.equals(cart.type)) continue;
            return cart;
        }
        return BASIC;
    }

    public static EnumCart fromCart(EntityMinecart cart) {
        return EnumCart.fromClass(cart.getClass());
    }

    static {
        VALUES = EnumCart.values();
    }
}

