/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.carts.TransferCartBase;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class EntityCartChest
extends TransferCartBase {
    public EntityCartChest(World world) {
        super(world);
    }

    public EntityCartChest(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    public List getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ItemStack(Item.field_77773_az));
            items.add(new ItemStack((Block)Block.field_72077_au));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    @Override
    public ItemStack getCartItem() {
        ItemStack stack = new ItemStack(Item.field_77762_aN);
        if (this.func_94042_c()) {
            stack.func_82834_c(this.func_70023_ak());
        }
        return stack;
    }

    @Override
    public double getDrag() {
        return 0.991999979019165;
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.field_70170_p)) {
            player.func_71007_a((IInventory)this);
        }
        return true;
    }

    @Override
    public int func_94087_l() {
        return 1;
    }

    public Block func_94089_m() {
        return Block.field_72077_au;
    }

    public int func_94085_r() {
        return 8;
    }

    public boolean canBeRidden() {
        return false;
    }

    public int func_70302_i_() {
        return 27;
    }

    public String func_70303_b() {
        return "Chest Cart";
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!RailcraftConfig.chestAllowLiquids()) {
            return this.func_70301_a(slot) == null || FluidHelper.getFluidStackInContainer(stack) == null;
        }
        return true;
    }
}

