/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IExplosiveCart;
import mods.railcraft.common.carts.CartBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class CartExplosiveBase
extends CartBase
implements IExplosiveCart,
IGuiReturnHandler {
    private static final byte FUSE_DATA_ID = 25;
    private static final byte BLAST_DATA_ID = 26;
    private static final byte PRIMED_DATA_ID = 27;
    private static final float BLAST_RADIUS_BYTE_MULTIPLIER = 0.5f;
    private static final float BLAST_RADIUS_MIN = 2.0f;
    private static final float BLAST_RADIUS_MAX = 6.0f;
    private static final float BLAST_RADIUS_MAX_BONUS = 5.0f;
    public static final short MAX_FUSE = 500;
    public static final short MIN_FUSE = 0;
    private boolean isExploding;

    public CartExplosiveBase(World world) {
        super(world);
    }

    public CartExplosiveBase(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)80);
        this.field_70180_af.func_75682_a(26, (Object)8);
        this.field_70180_af.func_75682_a(27, (Object)0);
    }

    public Block func_94089_m() {
        return Block.field_72091_am;
    }

    public void func_70071_h_() {
        double d0;
        super.func_70071_h_();
        if (this.field_70123_F && (d0 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) >= 0.01) {
            this.explode(this.getBlastRadiusWithSpeedModifier());
        }
        if (this.isPrimed()) {
            this.setFuse((short)(this.getFuse() - 1));
            if (this.getFuse() <= 0) {
                this.explode();
            } else {
                this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u + 0.8, this.field_70161_v, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void explode() {
        this.explode(this.getBlastRadius());
    }

    protected void explode(float blastRadius) {
        this.isExploding = true;
        if (Game.isHost(this.getWorld())) {
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, blastRadius, true);
            this.func_70106_y();
        }
    }

    @Override
    public void func_94095_a(DamageSource damageSource) {
        if (this.field_70128_L || this.isExploding) {
            return;
        }
        double speedSq = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y;
        if (damageSource.func_76347_k() || damageSource.func_94541_c() || speedSq >= 0.01) {
            this.explode(this.getBlastRadiusWithSpeedModifier());
        } else {
            super.func_94095_a(damageSource);
        }
    }

    protected float getBlastRadiusWithSpeedModifier() {
        double blast = Math.min(CartTools.getCartSpeedUncapped(this), (double)this.getMaxBlastRadiusBonus());
        return (float)((double)this.getBlastRadius() + this.field_70146_Z.nextDouble() * 1.5 * blast);
    }

    protected float getBlastRadiusWithFallModifier(float distance) {
        double blast = Math.min((double)distance / 10.0, (double)this.getMaxBlastRadiusBonus());
        return (float)((double)this.getBlastRadius() + this.field_70146_Z.nextDouble() * 1.5 * blast);
    }

    public void func_96095_a(int x, int y, int z, boolean powered) {
        this.setPrimed(powered);
    }

    protected void func_70069_a(float distance) {
        if (distance >= 3.0f) {
            this.explode(this.getBlastRadiusWithFallModifier(distance));
        }
        super.func_70069_a(distance);
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null) {
            if (itemstack.field_77993_c == Item.field_77709_i.field_77779_bT) {
                this.setPrimed(true);
            } else if (itemstack.field_77993_c == Item.field_77683_K.field_77779_bT) {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                GuiHandler.openGui(EnumGui.CART_TNT_FUSE, player, this.field_70170_p, (Entity)this);
            } else if (itemstack.field_77993_c == Item.field_77677_M.field_77779_bT) {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                GuiHandler.openGui(EnumGui.CART_TNT_BLAST, player, this.field_70170_p, (Entity)this);
            }
        }
        return true;
    }

    public boolean canBeRidden() {
        return false;
    }

    @Override
    public boolean isPrimed() {
        return this.field_70180_af.func_75683_a(27) != 0;
    }

    @Override
    public void setPrimed(boolean primed) {
        if (Game.isHost(this.field_70170_p) && this.isPrimed() != primed) {
            if (primed) {
                this.field_70170_p.func_72956_a((Entity)this, "random.fuse", 1.0f, 1.0f);
            }
            this.field_70180_af.func_75692_b(27, (Object)(primed ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0)));
        }
    }

    @Override
    public int getFuse() {
        return this.field_70180_af.func_75693_b(25);
    }

    @Override
    public void setFuse(int f) {
        f = (short)Math.max(f, 0);
        f = (short)Math.min(f, 500);
        this.field_70180_af.func_75692_b(25, (Object)((short)f));
    }

    protected float getMinBlastRadius() {
        return 2.0f;
    }

    protected float getMaxBlastRadius() {
        return 6.0f;
    }

    protected float getMaxBlastRadiusBonus() {
        return 5.0f;
    }

    @Override
    public float getBlastRadius() {
        return (float)this.field_70180_af.func_75683_a(26) * 0.5f;
    }

    @Override
    public void setBlastRadius(float b) {
        b = Math.max(b, this.getMinBlastRadius());
        b = Math.min(b, this.getMaxBlastRadius());
        this.field_70180_af.func_75692_b(26, (Object)((byte)(b /= 0.5f)));
    }

    protected void func_70014_b(NBTTagCompound data) {
        super.func_70014_b(data);
        data.func_74777_a("Fuse", (short)this.getFuse());
        data.func_74774_a("blastRadius", this.field_70180_af.func_75683_a(26));
        data.func_74757_a("Primed", this.isPrimed());
    }

    protected void func_70037_a(NBTTagCompound data) {
        super.func_70037_a(data);
        this.setFuse(data.func_74765_d("Fuse"));
        this.setBlastRadius(data.func_74771_c("blastRadius"));
        this.setPrimed(data.func_74767_n("Primed"));
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeShort(this.getFuse());
        data.writeByte(this.field_70180_af.func_75683_a(26));
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.setFuse(data.readShort());
        this.setBlastRadius(data.readByte());
    }

    @Override
    public World getWorld() {
        return this.field_70170_p;
    }

    @Override
    public double getDrag() {
        return 0.991999979019165;
    }
}

