/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import mods.railcraft.api.tracks.ITrackLockdown;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackLockingBase;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.item.EntityMinecart;

public class TrackLockdown
extends TrackLockingBase
implements ITrackPowered,
ITrackLockdown {
    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.LOCKDOWN;
    }

    @Override
    public void updateEntity() {
        if (this.getCurrentCart() != null && this.getCurrentCart().field_70128_L) {
            this.setCurrentCart(null);
        }
        if (Game.isHost(this.getWorld())) {
            if (this.isPowered()) {
                this.delay = this.getDelayTime();
            } else if (this.delay > 0) {
                this.delay = (byte)(this.delay - 1);
                if (this.delay == 0) {
                    this.setCurrentCart(null);
                }
            }
        }
        if (this.prevDelay == 0 ^ this.delay == 0) {
            this.sendUpdateToClient();
        }
        this.prevDelay = this.delay;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        this.checkCart(cart);
        if (!this.isPowered() && this.delay <= 0) {
            if (this.getCurrentCart() == null) {
                this.setCurrentCart(cart);
            }
            if (this.getCurrentCart() == cart) {
                this.lockCart(cart);
                cart.field_70159_w = 0.0;
                cart.field_70179_y = 0.0;
                int meta = this.tileEntity.func_70322_n();
                if (meta == 0 || meta == 4 || meta == 5) {
                    cart.field_70161_v = (double)this.tileEntity.field_70327_n + 0.5;
                } else {
                    cart.field_70165_t = (double)this.tileEntity.field_70329_l + 0.5;
                }
            }
        } else {
            this.releaseCart(cart);
        }
    }
}

