/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.ItemSignalTuner;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TileBoxCapacitor
extends TileBoxBase
implements IGuiReturnHandler {
    protected int update = MiscTools.getRand().nextInt();
    private short ticksPowered;
    public short ticksToPower = (short)200;

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_CAPACITOR;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (player.func_70093_af()) {
            return false;
        }
        ItemStack current = player.func_71045_bC();
        if (current != null && current.func_77973_b() instanceof ItemSignalTuner) {
            return super.blockActivated(side, player);
        }
        GuiHandler.openGui(EnumGui.BOX_CAPACITOR, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public void func_70316_g() {
        ++this.update;
        if (Game.isNotHost(this.field_70331_k)) {
            return;
        }
        if (this.ticksPowered > 0) {
            this.ticksPowered = (short)(this.ticksPowered - 1);
            if (this.ticksPowered <= 0) {
                this.updateNeighbors();
            }
        }
    }

    @Override
    public void onNeighborStateChange(TileBoxBase neighbor) {
        if (neighbor.isEmitingRedstone()) {
            this.ticksPowered = this.ticksToPower;
            this.updateNeighbors();
        }
    }

    private void updateNeighbors() {
        this.sendUpdateToClient();
        int blockID = this.getBlockId();
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, blockID);
    }

    @Override
    public int getPowerOutput(int side) {
        TileEntity tile = this.tileCache.getTileOnSide(MiscTools.getOppositeSide(side));
        if (tile instanceof TileBoxBase) {
            return 0;
        }
        return this.ticksPowered > 0 ? 15 : 0;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74777_a("ticksPowered", this.ticksPowered);
        data.func_74777_a("ticksToPower", this.ticksToPower);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.ticksPowered = data.func_74765_d("ticksPowered");
        this.ticksToPower = data.func_74765_d("ticksToPower");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.ticksPowered > 0);
        data.writeShort(this.ticksToPower);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.ticksPowered = (short)(data.readBoolean() ? 1 : 0);
        this.ticksToPower = data.readShort();
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeShort(this.ticksToPower);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.ticksToPower = data.readShort();
    }

    @Override
    public boolean isConnected(ForgeDirection side) {
        TileEntity tile = this.tileCache.getTileOnSide(side);
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canTransferAspect();
        }
        return false;
    }

    @Override
    public SignalAspect getBoxSignalAspect() {
        return this.ticksPowered > 0 ? SignalAspect.RED : SignalAspect.OFF;
    }

    @Override
    public boolean canReceiveAspect() {
        return true;
    }
}

